/*
 * Decompiled with CFR 0.152.
 */
package kickass.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kickass.constant.Constant;
import kickass.function.DoubleX3Function;
import kickass.function.Function;
import kickass.function.special.Function0Arg;
import kickass.function.special.Function1Arg;
import kickass.function.special.Function3Arg;
import kickass.libraries.Library;
import kickass.values.MatrixValue;
import kickass.values.Value;
import kickass.values.VectorValue;
import kickassu.parsing.sourcelocation.SourceRange;

public class VectorLibrary
implements Library {
    @Override
    public String getName() {
        return "Vector";
    }

    public List<Constant> getConstants() {
        return new ArrayList<Constant>();
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function0Arg("Vector", sourceRange -> new VectorValue(0.0, 0.0, 0.0)));
        arrayList.add(new Function3Arg("Vector", VectorValue.invalid, (value, value2, value3, sourceRange) -> new VectorValue(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange), value3.getDouble((SourceRange)sourceRange))));
        arrayList.add(new Function0Arg("Matrix", sourceRange -> new MatrixValue(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}})));
        arrayList.add(new DoubleX3Function("RotationMatrix", (Value)MatrixValue.invalid){

            @Override
            protected Value f(double d, double d2, double d3) {
                double d4 = Math.cos(d);
                double d5 = Math.sin(d);
                double d6 = Math.cos(d2);
                double d7 = Math.sin(d2);
                double d8 = Math.cos(d3);
                double d9 = Math.sin(d3);
                double[][] dArrayArray = new double[][]{{d8 * d6, d8 * d7 * d5 - d9 * d4, d8 * d7 * d4 + d9 * d5, 0.0}, {d9 * d6, d9 * d7 * d5 + d8 * d4, d9 * d7 * d4 - d8 * d5, 0.0}, {-d7, d6 * d5, d6 * d4, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(dArrayArray);
            }
        });
        arrayList.add(new DoubleX3Function("ScaleMatrix", (Value)MatrixValue.invalid){

            @Override
            protected Value f(double d, double d2, double d3) {
                double[][] dArrayArray = new double[][]{{d, 0.0, 0.0, 0.0}, {0.0, d2, 0.0, 0.0}, {0.0, 0.0, d3, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(dArrayArray);
            }
        });
        arrayList.add(new Function3Arg("MoveMatrix", MatrixValue.invalid, (value, value2, value3, sourceRange) -> new MatrixValue(new double[][]{{1.0, 0.0, 0.0, value.getDouble((SourceRange)sourceRange)}, {0.0, 1.0, 0.0, value2.getDouble((SourceRange)sourceRange)}, {0.0, 0.0, 1.0, value3.getDouble((SourceRange)sourceRange)}, {0.0, 0.0, 0.0, 1.0}})));
        arrayList.add(new Function1Arg("PerspectiveMatrix", MatrixValue.invalid, (value, sourceRange) -> new MatrixValue(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0 / value.getDouble((SourceRange)sourceRange), 0.0}})));
        return arrayList;
    }
}

