/*
 * Decompiled with CFR 0.152.
 */
package kickass.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kickass.constant.Constant;
import kickass.function.Function;
import kickass.function.special.Function0Arg;
import kickass.function.special.Function1Arg;
import kickass.function.special.Function2Arg;
import kickass.libraries.Library;
import kickass.state.EvaluationState;
import kickass.values.HashtableValue;
import kickass.values.ListValue;
import kickass.values.NumberValue;
import kickass.values.OutputFileValue;
import kickass.values.Value;
import kickass.values._65xxArgumentValue;
import kickassu._65xx._65xxArgType;
import kickassu._65xx._65xxArgTypeUtil;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class StdConstructorLibrary
implements Library {
    @Override
    public String getName() {
        return "Constructors";
    }

    public List<Constant> getConstants() {
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        arrayList.add(new Constant("AT_ABSOLUTE", new NumberValue(_65xxArgType.unresolvedAbsolute.getIdNo())));
        arrayList.add(new Constant("AT_ZEROPAGE", new NumberValue(_65xxArgType.zeropage.getIdNo())));
        arrayList.add(new Constant("AT_ABSOLUTEX", new NumberValue(_65xxArgType.unresolvedAbsoluteX.getIdNo())));
        arrayList.add(new Constant("AT_ABSOLUTEY", new NumberValue(_65xxArgType.unresolvedAbsoluteY.getIdNo())));
        arrayList.add(new Constant("AT_IMMEDIATE", new NumberValue(_65xxArgType.immediate.getIdNo())));
        arrayList.add(new Constant("AT_INDIRECT", new NumberValue(_65xxArgType.indirect.getIdNo())));
        arrayList.add(new Constant("AT_IZEROPAGEX", new NumberValue(_65xxArgType.indirectZeropageX.getIdNo())));
        arrayList.add(new Constant("AT_IZEROPAGEY", new NumberValue(_65xxArgType.indirectZeropageY.getIdNo())));
        arrayList.add(new Constant("AT_NONE", new NumberValue(_65xxArgType.noArgument.getIdNo())));
        return arrayList;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function("createFile", 1, OutputFileValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                return new OutputFileValue(valueArray[0].getString(sourceRange), evaluationState);
            }
        });
        arrayList.add(new Function0Arg("List", sourceRange -> new ListValue(0)));
        arrayList.add(new Function1Arg("List", ListValue.invalid, (value, sourceRange) -> new ListValue(value.getInt((SourceRange)sourceRange))));
        arrayList.add(new Function0Arg("Hashtable", sourceRange -> new HashtableValue()));
        arrayList.add(new Function2Arg("CmdArgument", (value, value2, sourceRange) -> {
            if (value.isInvalid()) {
                throw new AsmErrorException("The type is an invalid value", (SourceRange)sourceRange);
            }
            if (!value2.hasDouble()) {
                throw new AsmErrorException("a " + value.getType() + "is not a valid value argument", (SourceRange)sourceRange);
            }
            int n = value.getInt((SourceRange)sourceRange);
            _65xxArgType _65xxArgType2 = _65xxArgTypeUtil.getArgType(n, sourceRange);
            return new _65xxArgumentValue(_65xxArgType2, (Value)value2);
        }));
        return arrayList;
    }
}

