/*
 * Decompiled with CFR 0.152.
 */
package kickass.libraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kickass.constant.Constant;
import kickass.function.Function;
import kickass.function.special.Function1Arg;
import kickass.function.special.Function2Arg;
import kickass.libraries.Library;
import kickass.values.StringValue;
import kickassu.parsing.sourcelocation.SourceRange;

public class PrintLibrary
implements Library {
    @Override
    public String getName() {
        return "Print";
    }

    public List<Constant> getConstants() {
        return new ArrayList<Constant>();
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function1Arg("toIntString", StringValue.invalid, (value, sourceRange) -> new StringValue(Integer.toString(value.getInt((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toIntString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Integer.toString(value.getInt((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), ' '))));
        arrayList.add(new Function1Arg("toHexString", StringValue.invalid, (value, sourceRange) -> new StringValue(Integer.toHexString(value.getInt((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toHexString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Integer.toHexString(value.getInt((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), '0'))));
        arrayList.add(new Function1Arg("toBinaryString", StringValue.invalid, (value, sourceRange) -> new StringValue(Integer.toBinaryString(value.getInt((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toBinaryString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Integer.toBinaryString(value.getInt((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), '0'))));
        arrayList.add(new Function1Arg("toOctalString", StringValue.invalid, (value, sourceRange) -> new StringValue(Integer.toOctalString(value.getInt((SourceRange)sourceRange)))));
        arrayList.add(new Function2Arg("toOctalString", StringValue.invalid, (value, value2, sourceRange) -> new StringValue(PrintLibrary.padLeft(Integer.toOctalString(value.getInt((SourceRange)sourceRange)), value2.getInt((SourceRange)sourceRange), '0'))));
        return arrayList;
    }

    private static String padLeft(String string, int n, char c) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        String string2 = new String(cArray);
        return string2 + string;
    }
}

