/*
 * Decompiled with CFR 0.152.
 */
package kickass.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kickass.constant.Constant;
import kickass.function.Function;
import kickass.function.special.Function1Arg;
import kickass.libraries.AbstractLibrary;
import kickass.tools.tuples.Pair;
import kickass.values.NumberValue;
import kickassu._65xx._65xxArgType;
import kickassu._65xx._65xxArgTypeUtil;
import kickassu._65xx._65xxMnemonics;
import kickassu.parsing.sourcelocation.SourceRange;

public class MnemonicsLibrary
extends AbstractLibrary {
    public List<Constant> getConstants() {
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        this.addOpcodeConstants(_65xxMnemonics.get65xxMnemonics(), arrayList);
        this.addOpcodeConstants(_65xxMnemonics.getDtvMnemonics(), arrayList);
        return arrayList;
    }

    @Override
    public String getName() {
        return "65xxMnemonics";
    }

    private List<Constant> addOpcodeConstants(List<Pair<String, int[]>> list, List<Constant> list2) {
        for (Pair<String, int[]> pair : list) {
            String string = pair.getA();
            int[] nArray = pair.getB();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0) continue;
                String string2 = string.toUpperCase();
                if (i > 0) {
                    string2 = string2 + "_" + MnemonicsLibrary.typeToShortString(i);
                }
                list2.add(new Constant(string2, new NumberValue(nArray[i])));
            }
        }
        return list2;
    }

    public static String typeToShortString(int n) {
        _65xxArgType _65xxArgType2 = _65xxArgTypeUtil.getArgType(n, null);
        switch (_65xxArgType2) {
            case noArgument: {
                return "NONE";
            }
            case immediate: {
                return "IMM";
            }
            case zeropage: {
                return "ZP";
            }
            case zeropageX: {
                return "ZPX";
            }
            case zeropageY: {
                return "ZPY";
            }
            case indirectZeropageX: {
                return "IZPX";
            }
            case indirectZeropageY: {
                return "IZPY";
            }
            case absolute: {
                return "ABS";
            }
            case absoluteX: {
                return "ABSX";
            }
            case absoluteY: {
                return "ABSY";
            }
            case indirect: {
                return "IND";
            }
            case relative: {
                return "REL";
            }
        }
        return "Unknown type";
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function1Arg("asmCommandSize", NumberValue.invalid, (value, sourceRange) -> new NumberValue(_65xxMnemonics.opcodeToCmdSize(value.getInt((SourceRange)sourceRange)))));
        return arrayList;
    }
}

