/*
 * Decompiled with CFR 0.152.
 */
package kickass.functionnode;

import kickass.expressions.ExprNode;
import kickass.functionnode.FScopeNode;
import kickass.functionnode.FunctionDirective;
import kickass.functionnode.FunctionNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class IfFDirective
extends FunctionDirective {
    private ExprNode conditionExpr;
    private FunctionNode trueBody;
    private FunctionNode falseBody;

    public IfFDirective(ExprNode exprNode, FunctionNode functionNode, FunctionNode functionNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.conditionExpr = exprNode;
        this.trueBody = functionNode;
        this.falseBody = functionNode2;
    }

    @Override
    public FunctionNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        this.trueBody = new FScopeNode(this.trueBody, new SymbolScope(symbolScope, null));
        this.trueBody = this.trueBody.executeMetaRegistrations(evaluationState);
        if (this.falseBody != null) {
            this.falseBody = new FScopeNode(this.falseBody, new SymbolScope(symbolScope, null));
            this.falseBody = this.falseBody.executeMetaRegistrations(evaluationState);
        }
        return this;
    }

    @Override
    public FunctionNode executePrepass(EvaluationState evaluationState) {
        this.conditionExpr.executePrepass(evaluationState);
        this.trueBody = this.trueBody.executePrepass(evaluationState);
        if (this.falseBody != null) {
            this.falseBody = this.falseBody.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public void executeFunctionPass(EvaluationState evaluationState) {
        Value value = this.conditionExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("Invalid/Unresolved condition value. Can't resolve if", this.range);
        }
        boolean bl = value.getBoolean(this.range);
        if (bl) {
            this.trueBody.executeFunctionPass(evaluationState);
        } else if (this.falseBody != null) {
            this.falseBody.executeFunctionPass(evaluationState);
        }
    }
}

