/*
 * Decompiled with CFR 0.152.
 */
package kickass.functionnode;

import java.util.List;
import kickass.expressions.ExprNode;
import kickass.functionnode.FunctionDirective;
import kickass.functionnode.FunctionNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ErrorIfFDirective
extends FunctionDirective {
    private List<ExprNode> argExprs;

    public ErrorIfFDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.argExprs = list;
        this.range = sourceRange;
    }

    @Override
    public FunctionNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public FunctionNode executePrepass(EvaluationState evaluationState) {
        if (this.argExprs.size() != 2) {
            evaluationState.addError(new AsmError("Invalid number of arguments.", this.range));
            return this;
        }
        for (ExprNode exprNode : this.argExprs) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public void executeFunctionPass(EvaluationState evaluationState) {
        Value value = this.argExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
            return;
        }
        if (value.getBoolean(this.range)) {
            Value value2 = this.argExprs.get(1).evaluate(evaluationState);
            if (value2.isInvalid()) {
                evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
                return;
            }
            String string = value2.getString(this.range);
            throw new AsmErrorException(string, this.range);
        }
    }
}

