/*
 * Decompiled with CFR 0.152.
 */
package kickass.expressions;

import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class QuestionIf
extends ExprNode {
    private ExprNode conditionExpr;
    private ExprNode trueExpr;
    private ExprNode falseExpr;

    public QuestionIf(ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3, SourceRange sourceRange) {
        super(sourceRange);
        this.conditionExpr = exprNode;
        this.trueExpr = exprNode2;
        this.falseExpr = exprNode3;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.conditionExpr.executePrepass(evaluationState);
        this.trueExpr.executePrepass(evaluationState);
        this.falseExpr.executePrepass(evaluationState);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value = this.conditionExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("The condition must be able to evaluate in first parse", this.range);
        }
        return value.getBoolean(this.range) ? this.trueExpr.evaluate(evaluationState) : this.falseExpr.evaluate(evaluationState);
    }
}

