/*
 * Decompiled with CFR 0.152.
 */
package kickass.expressions;

import java.util.List;
import kickass.expressions.ExprNode;
import kickass.function.Function;
import kickass.function.functionselector.IFunctionSelector;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.ReturnException;
import kickassu.parsing.sourcelocation.SourceRange;

public class FunctionCall
extends ExprNode {
    private boolean isRootScope;
    private String functionName;
    private List<ExprNode> argExprs;
    private Function function = null;

    public FunctionCall(String string, SourceRange sourceRange, List<ExprNode> list) {
        super(sourceRange);
        this.argExprs = list;
        this.isRootScope = string.startsWith("@");
        this.functionName = this.isRootScope ? string.substring(1) : string;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        for (ExprNode exprNode : this.argExprs) {
            exprNode.executePrepass(evaluationState);
        }
        IFunctionSelector iFunctionSelector = evaluationState.getRootOrCurrentNamespace(this.isRootScope).getFunctions().get(this.functionName);
        if (iFunctionSelector == null) {
            evaluationState.addError(new AsmError("Unknown function '" + this.functionName + "'", this.range));
            return;
        }
        this.function = iFunctionSelector.getFunction(this.argExprs.size());
        if (this.function == null) {
            evaluationState.addError(new AsmError("Invalid number of arguments for function '" + this.functionName + "'", this.range));
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value;
        Value[] valueArray = new Value[this.argExprs.size()];
        boolean bl = false;
        for (int i = 0; i < valueArray.length; ++i) {
            Value value2 = this.argExprs.get(i).evaluate(evaluationState);
            bl |= value2.isInvalid();
            valueArray[i] = value2;
        }
        evaluationState.getCallStack().push(this.range);
        try {
            value = bl && !this.function.handlesInvalidArguments() ? this.function.getInvalidResult(valueArray) : this.function.execute(valueArray, evaluationState, this.range);
        }
        catch (ReturnException returnException) {
            value = returnException.getReturnValue();
        }
        evaluationState.getCallStack().pop();
        return value;
    }

    public String toString() {
        return this.functionName + "()";
    }
}

