/*
 * Decompiled with CFR 0.152.
 */
package kickass.expressions;

import kickass.expressions.ExprNode;
import kickass.referenceexpr.IReferenceExpr;
import kickass.referenceexpr.ReferenceOperation;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;

public class DeReference
extends ExprNode {
    private IReferenceExpr referenceExpr;

    public DeReference(IReferenceExpr iReferenceExpr) {
        super(iReferenceExpr.getSourceRange());
        this.referenceExpr = iReferenceExpr;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.referenceExpr.executePrepass(evaluationState, ReferenceOperation.read);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value = this.referenceExpr.getValueHolder(evaluationState).get(evaluationState, this.range);
        if (value.isInvalid()) {
            evaluationState.setErrorDuringFunctionEvaluation(true);
            if (evaluationState.failOnInvalidValue()) {
                throw new AsmErrorException("Value can't be resolved", this.range);
            }
        }
        return value;
    }

    public String toString() {
        return "DeReference";
    }
}

