/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.function.Function;
import kickass.functionnode.FunctionNode;
import kickass.functionnode.FunctionNodeList;
import kickass.state.EvaluationState;
import kickass.state.MetaConstructPosition;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.ISymbolTable;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;
import kickass.valueholder.FunctionVariableValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.NullValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.ReturnException;
import kickassu.parsing.sourcelocation.SourceRange;

class UserFunction
extends Function {
    private List<String> argumentNames;
    private FunctionNode body;
    private Namespace definitionNamespace;
    private SymbolScope innerScope;
    private SourceRange range;
    private ISymbolTable symbolTable;
    private ISymbolPageIdx[] argSymbolIdxs;

    protected UserFunction(String string, List<String> list, List<FunctionNode> list2, Namespace namespace, SourceRange sourceRange) {
        super(string, list.size(), null, true);
        this.range = sourceRange;
        this.argumentNames = list;
        this.definitionNamespace = namespace;
        this.body = new FunctionNodeList(list2);
        this.symbolTable = new SymbolTable();
        this.innerScope = new SymbolScope(namespace.getScope(), this.symbolTable);
        this.innerScope.setMetaConstructPosition(MetaConstructPosition.inFunction);
    }

    public void registerMetaDefinitions(EvaluationState evaluationState) {
        this.argSymbolIdxs = new ISymbolPageIdx[this.argumentNames.size()];
        for (int i = 0; i < this.argumentNames.size(); ++i) {
            String string = this.argumentNames.get(i);
            if (this.innerScope.isDefined(string)) {
                evaluationState.addError(new AsmError("The symbol '" + string + "' is already defined.", this.range));
            }
            this.argSymbolIdxs[i] = this.innerScope.define(string, FunctionVariableValueHolder.initializer);
            this.argSymbolIdxs[i].setStatus(SymbolStatus.defined);
        }
        SymbolScope symbolScope = evaluationState.replaceCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.setCurrentScope(symbolScope);
    }

    public void executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.replaceCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.setCurrentScope(symbolScope);
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        boolean bl;
        IValueHolder[] iValueHolderArray = this.symbolTable.replaceCurrentPage(this.symbolTable.createPage());
        Namespace namespace = evaluationState.replaceCurrentNamespace(this.definitionNamespace);
        for (bl = false; bl < this.argSymbolIdxs.length; bl += 1) {
            this.argSymbolIdxs[bl].getValueHolder().setWithoutSideEffect(valueArray[bl]);
        }
        bl = evaluationState.replaceFunctionMode(true);
        Value value = NullValue.instance;
        try {
            this.body.executeFunctionPass(evaluationState);
        }
        catch (ReturnException returnException) {
            value = returnException.getReturnValue();
        }
        evaluationState.setFunctionMode(bl);
        this.symbolTable.setCurrentPage(iValueHolderArray);
        evaluationState.setCurrentNamespace(namespace);
        return value;
    }
}

