/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.ByteOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.misc.CharToPetsciiConverter;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.parsing.sourcelocation.SourceRange;

public class TextBlockDirective
extends AsmDirective {
    private ExprNode stringExpr;

    public TextBlockDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.stringExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.stringExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.stringExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        String string = value.getString(this.range);
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = CharToPetsciiConverter.convert(string.charAt(i), true);
        }
        evaluationState.increaseMemoryPosition(string.length());
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byArray, this.range, evaluationState.getFunctionSideOutput());
    }
}

