/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.reciever.OutputReciever;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class PseudoPCDirective
extends AsmDirective {
    private ExprNode orgAddressExpr;
    private AsmNode body;
    boolean functionsEvalOk = false;

    public PseudoPCDirective(ExprNode exprNode, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.orgAddressExpr = exprNode;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new PseudoPCDirective(this.orgAddressExpr, this.body.copy(), this.range);
    }

    @Override
    public boolean isFinished() {
        return this.functionsEvalOk && this.body.isFinished();
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.body = this.body.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.orgAddressExpr.executePrepass(evaluationState);
        this.body = this.body.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (evaluationState.getPseudoPcMode()) {
            throw new AsmErrorException("You can't nest pseudo pc directives", this.range);
        }
        evaluationState.clearFunctionSideOutput();
        Value value = this.orgAddressExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.range);
        Integer n2 = evaluationState.getMemoryPosition();
        evaluationState.setMemoryPosition(n);
        evaluationState.setRealMemoryPosition(n2);
        evaluationState.setPseudoPcMode(true);
        this.body = this.body.executePass(evaluationState);
        evaluationState.setPseudoPcMode(false);
        evaluationState.setMemoryPosition(evaluationState.getRealMemoryPosition());
        this.functionsEvalOk = !evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        return this;
    }
}

