/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.Label;
import kickass.directives.LabelConnector;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.valueholder.ConstantValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.LabelValue;
import kickass.values.ScopeValue;
import kickass.values._65xxArgumentValue;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmException;
import kickassu.parsing.sourcelocation.SourceRange;

public class PseudoCommandExecution
extends AsmDirective
implements LabelConnector {
    private boolean isRootScope;
    private String name;
    private List<ExprNode> argumentExprs;
    private String labelId;
    private MacroDefinitionRootNode pseudoCmd;
    private ISymbolPageIdx labelPageIdx;

    public PseudoCommandExecution(String string, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
        this.argumentExprs = list;
    }

    @Override
    public boolean connectToLabel(Label label) {
        this.labelId = label.getName();
        return true;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) throws AsmException {
        for (ExprNode exprNode : this.argumentExprs) {
            exprNode.executePrepass(evaluationState);
        }
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        this.pseudoCmd = evaluationState.getRootOrCurrentNamespace(this.isRootScope).getPseudoCommands().get(this.name);
        if (this.pseudoCmd == null) {
            evaluationState.addError(new AsmError("Pseudo command '" + this.name + "' not defined", this.range));
            return EmptyOutput.instance;
        }
        int n = this.pseudoCmd.getArgumentNames().size();
        if (n < this.argumentExprs.size() && (n != 0 || this.argumentExprs.size() != 1)) {
            evaluationState.addError(new AsmError("Too many arguments for pseudo command", this.range));
            return EmptyOutput.instance;
        }
        if (this.labelId != null) {
            this.labelPageIdx = symbolScope.get(this.labelId);
            this.labelPageIdx.replaceInitializer(iValueHolderArray -> new ConstantValueHolder(new LabelValue(new ScopeValue(this.pseudoCmd.getInnerScope(), null))));
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        IValueHolder[] iValueHolderArray;
        if (this.labelId == null) {
            iValueHolderArray = this.pseudoCmd.getInnerScope().getSymbolTable().createPage();
        } else {
            LabelValue labelValue = (LabelValue)this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            iValueHolderArray = ((ScopeValue)labelValue.getConnectedValue()).getSymbolPage();
        }
        return this.pseudoCmd.instantiate(this.argumentExprs, _65xxArgumentValue.noArgument, iValueHolderArray, this.range).executePass(evaluationState);
    }
}

