/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.Directive;
import kickass.expressions.ExprNode;
import kickass.log.Log;
import kickass.sideeffect.SEPrintNow;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.parsing.sourcelocation.SourceRange;

public class PrintNowDirective
extends Directive {
    private static Log log = new Log("");
    private static final String indent = "   ";
    private ExprNode msgExpr;

    public PrintNowDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.msgExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.msgExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        String string = indent + value.getString(this.range);
        log.println(string);
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        evaluationState.addSideEffect(new SEPrintNow(string));
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }
}

