/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.Directive;
import kickass.directives.asmmode.AsmDirective;
import kickass.state.EvaluationState;
import kickassu.exceptions.AsmErrorException;
import kickassu.exceptions.NotImplementedException;
import kickassu.parsing.sourcelocation.SourceRange;

public class PluginDirective
extends AsmDirective {
    private String className;

    public PluginDirective(String string, SourceRange sourceRange) {
        super(sourceRange);
        this.className = string;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        Object obj;
        Class<?> clazz;
        try {
            clazz = Class.forName(this.className);
        }
        catch (Exception exception) {
            throw new AsmErrorException("Can't find class for plugin", this.range);
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new AsmErrorException("Plugin found but can't instantiate it", this.range);
        }
        evaluationState.addPlugin(obj);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }
}

