/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.NamespaceNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.Directive;
import kickass.state.EvaluationState;
import kickass.state.namespace.Namespace;
import kickassu.errors.AsmError;
import kickassu.exceptions.ShouldNotBeHereException;
import kickassu.parsing.sourcelocation.SourceRange;

public class NamespaceDirective
extends Directive {
    private AsmNode body;
    private String nameSpaceId;

    public NamespaceDirective(AsmNode asmNode, String string, SourceRange sourceRange) {
        super(sourceRange);
        this.body = asmNode;
        this.nameSpaceId = string;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        Namespace namespace = evaluationState.getCurrentNamespace();
        boolean bl2 = bl = namespace.getScope() == evaluationState.getCurrentScope();
        if (!bl) {
            evaluationState.addError(new AsmError("Can't define a new namespace here. You have to be in the scope of a parent namespace (Not inside .if, .for, .function, etc.).", this.range));
            return EmptyOutput.instance;
        }
        Namespace namespace2 = evaluationState.getCurrentNamespace().getSubspace(this.nameSpaceId, evaluationState, this.range);
        if (namespace2 == null) {
            return EmptyOutput.instance;
        }
        return new NamespaceNode(this.body, namespace2).executeMetaRegistrations(evaluationState);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode copy() {
        return new NamespaceDirective(this.body.copy(), this.nameSpaceId, this.range);
    }
}

