/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.values.LabelValue;
import kickass.values.NumberValue;
import kickassu.parsing.sourcelocation.SourceRange;

public class MultiLabelDirective
extends AsmDirective {
    private String name;
    private ISymbolPageIdx symbolIdx;

    public MultiLabelDirective(String string, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
    }

    private MultiLabelDirective(String string, SourceRange sourceRange, ISymbolPageIdx iSymbolPageIdx) {
        super(sourceRange);
        this.name = string;
        this.symbolIdx = iSymbolPageIdx;
    }

    @Override
    public AsmNode copy() {
        return new MultiLabelDirective(this.name, this.range, this.symbolIdx);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        this.symbolIdx = symbolScope.defineMultiSymbol(this.name, LabelValue.initializer);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        symbolScope.increaseMultiSymbolIdx(this.name);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Integer n = evaluationState.getMemoryPosition();
        if (n == null) {
            return this;
        }
        NumberValue numberValue = new NumberValue(n.intValue());
        this.symbolIdx.getValueHolder().setWithoutSideEffect(numberValue);
        evaluationState.setMadeMetaProgress();
        return EmptyOutput.instance;
    }

    @Override
    public String toString() {
        return "MultiLabel(" + this.name + ")";
    }
}

