/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.ArrayList;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.asmnode.output.reciever.CodeCollectorOutputReciever;
import kickass.asmnode.output.reciever.MainOutputReciever;
import kickass.asmnode.output.reciever.OutputReciever;
import kickass.asmnode.output.reciever.OutputStreamType;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.misc.MemoryBlock;
import kickass.plugins.impl.PluginEngine;
import kickass.plugins.impl.PluginValue;
import kickass.plugins.interf.IMemoryBlock;
import kickass.plugins.interf.IModifier;
import kickass.plugins.interf.IValue;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ModifyDirective
extends AsmDirective {
    private String name;
    private List<ExprNode> argumentExprs;
    private AsmNode body;
    private boolean isFinished = false;
    private FunctionSideOutput sideOutputFromArguments;
    private byte[] modifiedBytes;

    public ModifyDirective(String string, List<ExprNode> list, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.argumentExprs = list;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new ModifyDirective(this.name, this.argumentExprs, this.body.copy(), this.range);
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        evaluationState.clearFunctionSideOutput();
        boolean bl = false;
        IValue[] iValueArray = new IValue[this.argumentExprs.size()];
        for (int i = 0; i < iValueArray.length; ++i) {
            object = this.argumentExprs.get(i).evaluate(evaluationState);
            bl |= ((Value)object).isInvalid();
            iValueArray[i] = new PluginValue((Value)object, this.range);
        }
        this.sideOutputFromArguments = evaluationState.getFunctionSideOutput();
        Integer n = evaluationState.getMemoryPosition();
        evaluationState.setMemoryPosition(8192);
        this.body = this.body.executePass(evaluationState);
        evaluationState.setMemoryPosition(null);
        if (bl || !this.body.isFinished()) {
            return this;
        }
        if (this.modifiedBytes == null) {
            object = new CodeCollectorOutputReciever(8192, evaluationState.getMaxMemoryAddress());
            this.body.deliverOutput((OutputReciever)object);
            List<MemoryBlock> list = ((MainOutputReciever)object).getMemoryBlocks();
            ArrayList<IMemoryBlock> arrayList = new ArrayList<IMemoryBlock>();
            for (MemoryBlock object22 : list) {
                if (object22.isVirtual()) continue;
                arrayList.add(object22.getPluginMemoryBlock());
            }
            IModifier iModifier = evaluationState.getSystemNamespace().getModifierPlugins().get(this.name);
            if (iModifier == null) {
                throw new AsmErrorException("Unknown modifyer: " + this.name, this.range);
            }
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.range);
            this.modifiedBytes = iModifier.execute(arrayList, iValueArray, pluginEngine);
        }
        object = n == null ? null : Integer.valueOf(n + this.modifiedBytes.length);
        evaluationState.setMemoryPosition((Integer)object);
        this.isFinished = true;
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        new SideEffectOnlyOutput(this.sideOutputFromArguments).deliverOutput(outputReciever);
        this.body.deliverOutput(new ByteOutputFilter(outputReciever));
        outputReciever.addAssembledBytes(this.modifiedBytes, this.range);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.body.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.body.executeMetaRegistrations(evaluationState);
        return this;
    }

    static class ByteOutputFilter
    implements OutputReciever {
        private OutputReciever reciever;

        public ByteOutputFilter(OutputReciever outputReciever) {
            this.reciever = outputReciever;
        }

        @Override
        public void addToStream(OutputStreamType outputStreamType, String string, Object object) {
            this.reciever.addToStream(outputStreamType, string, object);
        }

        @Override
        public void addAssembledBytes(byte[] byArray, SourceRange sourceRange) {
        }

        @Override
        public void startNewMemoryBlock(int n, String string, boolean bl) {
        }

        @Override
        public List<MemoryBlock> getMemoryBlocks() {
            return this.reciever.getMemoryBlocks();
        }
    }
}

