/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.StartOfMemoryBlockOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class MemoryBlockDirective
extends AsmDirective {
    private SourceRange Range;
    private ExprNode startAddressExpr;
    private boolean isVirtual;
    private String name;
    boolean adressNotResolvedBefore = true;

    public MemoryBlockDirective(ExprNode exprNode, String string, Boolean bl, SourceRange sourceRange) {
        super(sourceRange);
        this.startAddressExpr = exprNode;
        this.isVirtual = bl;
        this.name = string == null ? "Unnamed" : string;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.startAddressExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (evaluationState.getPseudoPcMode()) {
            throw new AsmErrorException("You can't define a memoryblock inside the scope of a pseudopc directive", this.Range);
        }
        evaluationState.clearFunctionSideOutput();
        Value value = this.startAddressExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.Range);
        evaluationState.setMemoryPosition(n);
        if (this.adressNotResolvedBefore) {
            evaluationState.setMadeMetaProgress();
            this.adressNotResolvedBefore = false;
        }
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new StartOfMemoryBlockOutput(n, this.name, this.isVirtual, evaluationState.getFunctionSideOutput());
    }
}

