/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.asmnode.output.ByteOutput;
import kickass.asmnode.output.EmptyOutput;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.Label;
import kickass.directives.LabelConnector;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.log.Log;
import kickass.plugins.impl.PluginEngine;
import kickass.plugins.impl.PluginValue;
import kickass.plugins.interf.IMacro;
import kickass.plugins.interf.IValue;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;
import kickass.state.namespace.Namespace;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.valueholder.ConstantValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.LabelValue;
import kickass.values.ScopeValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.exceptions.AsmException;
import kickassu.parsing.sourcelocation.SourceRange;

public class MacroExecution
extends AsmDirective
implements LabelConnector {
    private static Log log = new Log("");
    private String name;
    private List<ExprNode> argumentExprs;
    private String labelId;
    ISymbolPageIdx labelPageIdx;
    MacroDefinitionRootNode macro;

    public MacroExecution(String string, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.argumentExprs = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public boolean connectToLabel(Label label) {
        this.labelId = label.getName();
        return true;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) throws AsmException {
        for (ExprNode object2 : this.argumentExprs) {
            object2.executePrepass(evaluationState);
        }
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        Namespace namespace = evaluationState.getRootOrCurrentNamespace(bl);
        MacroDefinitionRootNode macroDefinitionRootNode = namespace.getMacros().get(string);
        if (macroDefinitionRootNode != null) {
            return this.preParseStandardMacro(evaluationState, macroDefinitionRootNode);
        }
        IMacro iMacro = namespace.getMacroPlugins().get(string);
        if (iMacro != null) {
            return new PluginMacroExecution(iMacro, this.argumentExprs, this.range);
        }
        evaluationState.addError(new AsmError("Macro command '" + string + "' not defined", this.range));
        return EmptyOutput.instance;
    }

    private AsmNode preParseStandardMacro(EvaluationState evaluationState, MacroDefinitionRootNode macroDefinitionRootNode) throws AsmException {
        this.macro = macroDefinitionRootNode;
        List<String> list = macroDefinitionRootNode.getArgumentNames();
        if (list.size() != this.argumentExprs.size()) {
            evaluationState.addError(new AsmError("Invalid number of arguments for macro", this.range));
            return EmptyOutput.instance;
        }
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.getCurrentScope().get(this.labelId);
            this.labelPageIdx.replaceInitializer(iValueHolderArray -> new ConstantValueHolder(new LabelValue(new ScopeValue(macroDefinitionRootNode.getInnerScope(), null))));
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        IValueHolder[] iValueHolderArray;
        if (this.labelId == null) {
            iValueHolderArray = this.macro.getInnerScope().getSymbolTable().createPage();
        } else {
            LabelValue labelValue = (LabelValue)this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            iValueHolderArray = ((ScopeValue)labelValue.getConnectedValue()).getSymbolPage();
        }
        return this.macro.instantiate(this.argumentExprs, null, iValueHolderArray, this.range).executePass(evaluationState);
    }

    private static class PluginMacroExecution
    extends AsmDirective {
        private IMacro macro;
        private List<ExprNode> argumentExprs;

        public PluginMacroExecution(IMacro iMacro, List<ExprNode> list, SourceRange sourceRange) {
            super(sourceRange);
            this.macro = iMacro;
            this.argumentExprs = list;
        }

        @Override
        public AsmNode copy() {
            return this;
        }

        @Override
        public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
            return this;
        }

        @Override
        public AsmNode executePrepass(EvaluationState evaluationState) {
            for (int i = 0; i < this.argumentExprs.size(); ++i) {
                this.argumentExprs.get(i).executePrepass(evaluationState);
            }
            return this;
        }

        @Override
        public AsmNode executePass(EvaluationState evaluationState) {
            Object object;
            Object object2;
            evaluationState.clearFunctionSideOutput();
            IValue[] iValueArray = new IValue[this.argumentExprs.size()];
            boolean bl = false;
            for (int i = 0; i < iValueArray.length; ++i) {
                object2 = this.argumentExprs.get(i);
                object = this.argumentExprs.get(i).evaluate(evaluationState);
                bl |= ((Value)object).isInvalid();
                iValueArray[i] = new PluginValue((Value)object, ((ExprNode)object2).getSourceRange());
            }
            if (bl) {
                return this;
            }
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.range);
            try {
                object2 = this.macro.execute(iValueArray, pluginEngine);
            }
            catch (Throwable throwable) {
                if (throwable instanceof AsmErrorException) {
                    throw (AsmErrorException)throwable;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                throwable.printStackTrace(printStream);
                log.println(byteArrayOutputStream.toString());
                throw new AsmErrorException("Exception while executing plugin macro", this.range);
            }
            if (object2 != null) {
                evaluationState.increaseMemoryPosition(((Object)object2).length);
            }
            object = evaluationState.getFunctionSideOutput();
            return object2 == null ? new SideEffectOnlyOutput((FunctionSideOutput)object) : new ByteOutput((byte[])object2, this.range, (FunctionSideOutput)object);
        }
    }
}

