/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.AsmNodeList;
import kickass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.state.EvaluationState;
import kickass.state.MetaConstructPosition;
import kickass.state.scope.EntityScope;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmException;
import kickassu.exceptions.ShouldNotBeHereException;
import kickassu.parsing.sourcelocation.SourceRange;

public class MacroDefinition
extends AsmDirective {
    private boolean isRootScope;
    private String name;
    private List<String> argNames;
    private List<AsmNode> body;
    private MacroDefinitionRootNode rootNode;

    public MacroDefinition(String string, List<String> list, List<AsmNode> list2, SourceRange sourceRange) {
        super(sourceRange);
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
        this.argNames = list;
        this.body = list2;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2 = bl = evaluationState.getCurrentNamespace().getScope() == evaluationState.getCurrentScope();
        if (!bl) {
            evaluationState.addError(new AsmError("Can't define a macro here. Define it in the direct scope of the current namespace, not inside constructs like {}, .if, .for etc.", this.range));
            return EmptyOutput.instance;
        }
        EntityScope<MacroDefinitionRootNode> entityScope = evaluationState.getRootOrCurrentNamespace(this.isRootScope).getMacros();
        if (entityScope.getLocalDefinedEntities().containsKey(this.name)) {
            evaluationState.addError(new AsmError("The macro '" + this.name + "'  is already defined", this.range));
        }
        this.rootNode = new MacroDefinitionRootNode(this.argNames, new AsmNodeList(this.body), evaluationState.getCurrentNamespace(), MetaConstructPosition.inMacro, this.range);
        entityScope.put(this.name, this.rootNode);
        this.rootNode.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.rootNode.executePrepass(evaluationState);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        throw new ShouldNotBeHereException();
    }
}

