/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.Label;
import kickass.directives.asmmode.AsmDirective;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.values.LabelValue;
import kickass.values.NumberValue;
import kickassu.errors.AsmError;
import kickassu.parsing.sourcelocation.SourceRange;

public class LabelDirective
extends AsmDirective
implements Label {
    private String name;
    private ISymbolPageIdx symbolIdx;

    public LabelDirective(String string, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
    }

    private LabelDirective(String string, ISymbolPageIdx iSymbolPageIdx, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.symbolIdx = iSymbolPageIdx;
    }

    @Override
    public AsmNode copy() {
        return new LabelDirective(this.name, this.symbolIdx, this.range);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.addError(new AsmError("The symbol '" + this.name + "' is already defined", this.range));
            return this;
        }
        this.symbolIdx = symbolScope.define(string, LabelValue.initializer);
        this.symbolIdx.setStatus(SymbolStatus.defined);
        this.symbolIdx.setIsScopeExposed(true);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Integer n = evaluationState.getMemoryPosition();
        if (n == null) {
            return this;
        }
        NumberValue numberValue = new NumberValue(n.intValue());
        LabelValue labelValue = (LabelValue)this.symbolIdx.getValueHolder().getWithoutSideeffect();
        labelValue.resolveLabel(numberValue);
        evaluationState.addResolvedSymbol(this.name, n);
        evaluationState.setMadeMetaProgress();
        return EmptyOutput.instance;
    }

    @Override
    public String toString() {
        return "Label(" + this.name + ")";
    }
}

