/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.Label;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.values.LabelValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class LabelAssignmentDirective
extends AsmDirective
implements Label {
    private String name;
    private ExprNode valueExpr;
    private ISymbolPageIdx symbolPageIdx;

    public LabelAssignmentDirective(String string, ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.valueExpr = exprNode;
    }

    private LabelAssignmentDirective(String string, ExprNode exprNode, ISymbolPageIdx iSymbolPageIdx, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.valueExpr = exprNode;
        this.symbolPageIdx = iSymbolPageIdx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AsmNode copy() {
        return new LabelAssignmentDirective(this.name, this.valueExpr, this.symbolPageIdx, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.addError(new AsmError("The symbol '" + string + "' is already defined", this.range));
            return this;
        }
        this.symbolPageIdx = symbolScope.define(string, LabelValue.initializer);
        this.symbolPageIdx.setStatus(SymbolStatus.defined);
        this.symbolPageIdx.setIsScopeExposed(true);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.valueExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.valueExpr.evaluate(evaluationState);
        if (value.isInvalidOrInvalidContent()) {
            return this;
        }
        if (!value.hasDouble()) {
            throw new AsmErrorException("The value of a label is expected to be a number value. This expression returns a value of type '" + value.getType() + "'", this.range);
        }
        LabelValue labelValue = (LabelValue)this.symbolPageIdx.getValueHolder().getWithoutSideeffect();
        labelValue.resolveLabel(value);
        evaluationState.addResolvedSymbol(this.name, value.getInt(this.range));
        evaluationState.setMadeMetaProgress();
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public String toString() {
        return "Label(" + this.name + ")";
    }
}

