/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.ByteOutput;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.Directive;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.misc.CharToPetsciiConverter;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ImportTextDirective
extends AsmDirective {
    private List<ExprNode> argumentExprs;

    public ImportTextDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.argumentExprs = list;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.argumentExprs.size() < 1 || 3 < this.argumentExprs.size()) {
            evaluationState.addError(new AsmError("Invalid number of arguments.", this.range));
            return EmptyOutput.instance;
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        Object object2;
        evaluationState.clearFunctionSideOutput();
        Value value = this.argumentExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("Must be able to solve filename during first pass", this.range);
        }
        String string = value.getString(this.range);
        Integer n = null;
        if (this.argumentExprs.size() >= 2) {
            object2 = this.argumentExprs.get(1).evaluate(evaluationState);
            if (((Value)object2).isInvalid()) {
                throw new AsmErrorException("Must be able to solve offset argument during first pass", this.range);
            }
            n = ((Value)object2).getInt(this.range);
            if (n < 0) {
                throw new AsmErrorException("Offset can't be negative", this.range);
            }
        }
        object2 = null;
        if (this.argumentExprs.size() >= 3) {
            object = this.argumentExprs.get(2).evaluate(evaluationState);
            if (((Value)object).isInvalid()) {
                throw new AsmErrorException("Must be able to solve length argument during first pass", this.range);
            }
            object2 = ((Value)object).getInt(this.range);
            if ((Integer)object2 < 0) {
                throw new AsmErrorException("Length can't be negative", this.range);
            }
        }
        object = evaluationState.getFileManager().openFileOrFail(string, false, this.range);
        byte[] byArray = new byte[]{};
        try {
            int n2;
            int n3;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
            int n4 = 65536;
            char[] cArray = new char[n4];
            if (n != null) {
                inputStreamReader.read(cArray, 0, n);
            }
            if (object2 != null) {
                n4 = (Integer)object2;
            }
            if ((n3 = inputStreamReader.read(cArray, 0, n4)) < 0) {
                n3 = 0;
            }
            int n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                if (CharToPetsciiConverter.convert(cArray[n2]) == null) continue;
                ++n5;
            }
            if (object2 != null && n5 < (Integer)object2) {
                throw new AsmErrorException("File is too short for the desired length", this.range);
            }
            byArray = new byte[n5];
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                Byte by = CharToPetsciiConverter.convert(cArray[i]);
                if (by == null) continue;
                byArray[n2++] = by;
            }
        }
        catch (Exception exception) {
            throw new AsmErrorException("Can't read file: " + string, this.range);
        }
        evaluationState.increaseMemoryPosition(byArray.length);
        return new ByteOutput(byArray, this.range, evaluationState.getFunctionSideOutput());
    }
}

