/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.io.File;
import java.util.List;
import kickass.AssemblerToolbox;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.FileImportNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.Directive;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.Constant;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.StringValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.ShouldNotBeHereException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ImportSourceDirective
extends AsmDirective {
    private List<ExprNode> argumentExprs;

    public ImportSourceDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.argumentExprs = list;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.argumentExprs.size() != 1) {
            evaluationState.addError(new AsmError("Invalid number of arguments. Import source takes exactly one argument", this.range));
            return EmptyOutput.instance;
        }
        ExprNode exprNode = this.argumentExprs.get(0);
        String string = this.getStringConstant(exprNode, evaluationState);
        if (string == null) {
            evaluationState.addError(new AsmError("Import source must be given a string constant as argument", exprNode.getSourceRange()));
            return EmptyOutput.instance;
        }
        File file = evaluationState.getFileManager().getFile(string, true);
        if (file == null) {
            evaluationState.addError(new AsmError("Can't open file: " + string, this.range));
            return EmptyOutput.instance;
        }
        if (evaluationState.getFileManager().isFileExcludedForImport(file)) {
            return EmptyOutput.instance;
        }
        AsmNode asmNode = AssemblerToolbox.loadAndLexOrError(string, evaluationState, this.range);
        if (asmNode == null) {
            return EmptyOutput.instance;
        }
        File file2 = file.getParentFile();
        asmNode = new FileImportNode(asmNode, file2, this.range);
        return asmNode.executeMetaRegistrations(evaluationState);
    }

    private String getStringConstant(ExprNode exprNode, EvaluationState evaluationState) {
        if (!(exprNode instanceof Constant)) {
            return null;
        }
        Value value = exprNode.evaluate(evaluationState);
        return value instanceof StringValue ? value.getString(null) : null;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }
}

