/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.ScopeNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.Directive;
import kickass.expressions.ExprNode;
import kickass.sideeffect.SideEffect;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;
import kickass.state.scope.SymbolScope;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class IfDirective
extends Directive {
    private ExprNode conditionExpr;
    private AsmNode trueBody;
    private AsmNode falseBody;
    private boolean conditionDone = false;
    private FunctionSideOutput conditionSideEffects;
    private AsmNode selectedBody = null;

    public IfDirective(ExprNode exprNode, AsmNode asmNode, AsmNode asmNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.conditionExpr = exprNode;
        this.trueBody = asmNode;
        this.falseBody = asmNode2;
    }

    @Override
    public AsmNode copy() {
        AsmNode asmNode = this.falseBody == null ? null : this.falseBody.copy();
        return new IfDirective(this.conditionExpr, this.trueBody.copy(), asmNode, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        this.trueBody = new ScopeNode(this.trueBody, new SymbolScope(symbolScope, null));
        this.trueBody = this.trueBody.executeMetaRegistrations(evaluationState);
        if (this.falseBody != null) {
            this.falseBody = new ScopeNode(this.falseBody, new SymbolScope(symbolScope, null));
            this.falseBody = this.falseBody.executeMetaRegistrations(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.conditionExpr.executePrepass(evaluationState);
        this.trueBody = this.trueBody.executePrepass(evaluationState);
        if (this.falseBody != null) {
            this.falseBody = this.falseBody.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (this.conditionDone) {
            this.execSideEffects(this.conditionSideEffects, evaluationState);
        } else {
            evaluationState.clearFunctionSideOutput();
            Value value = this.conditionExpr.evaluate(evaluationState);
            if (value.isInvalid()) {
                throw new AsmErrorException("The condition must be able to evaluate in first parse", this.range);
            }
            AsmNode asmNode = this.selectedBody = value.getBoolean(this.range) ? this.trueBody : this.falseBody;
            if (this.selectedBody == null) {
                this.selectedBody = EmptyOutput.instance;
            }
            if (!evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
                this.conditionDone = true;
                this.conditionSideEffects = evaluationState.getFunctionSideOutput();
            }
        }
        this.selectedBody = this.selectedBody.executePass(evaluationState);
        if (this.conditionDone && this.conditionSideEffects == null) {
            return this.selectedBody;
        }
        return this;
    }

    private void execSideEffects(FunctionSideOutput functionSideOutput, EvaluationState evaluationState) {
        if (functionSideOutput != null) {
            for (SideEffect sideEffect : functionSideOutput.getSideEffects()) {
                sideEffect.evaluate(evaluationState, this.range);
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.selectedBody != null && this.selectedBody.isFinished();
    }
}

