/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.directives.asmmode.UserFunction;
import kickass.function.Function;
import kickass.function.functionselector.IFunctionSelector;
import kickass.function.functionselector.MultiFunctionSelector;
import kickass.functionnode.FunctionNode;
import kickass.state.EvaluationState;
import kickass.state.scope.EntityScope;
import kickassu.errors.AsmError;
import kickassu.exceptions.ShouldNotBeHereException;
import kickassu.parsing.sourcelocation.SourceRange;

public class FunctionDeclarationDirective
extends AsmDirective {
    private boolean isRootScope;
    private String name;
    private List<String> argumentNames;
    private List<FunctionNode> body;
    private UserFunction function;

    public FunctionDeclarationDirective(String string, List<String> list, List<FunctionNode> list2, SourceRange sourceRange) {
        super(sourceRange);
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
        this.argumentNames = list;
        this.body = list2;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2;
        EntityScope<IFunctionSelector> entityScope = evaluationState.getRootOrCurrentNamespace(this.isRootScope).getFunctions();
        IFunctionSelector iFunctionSelector = entityScope.getLocalDefinedEntities().get(this.name);
        if (iFunctionSelector == null) {
            iFunctionSelector = new MultiFunctionSelector(this.name, new Function[0]);
            entityScope.put(this.name, iFunctionSelector);
        }
        boolean bl3 = bl2 = evaluationState.getCurrentNamespace().getScope() == evaluationState.getCurrentScope();
        if (!bl2) {
            evaluationState.addError(new AsmError("Can't define a function here. Define it in the direct scope of the current namespace, not inside constructs like {}, .if, .for, etc.", this.range));
            return EmptyOutput.instance;
        }
        this.function = new UserFunction(this.name, this.argumentNames, this.body, evaluationState.getCurrentNamespace(), this.range);
        boolean bl4 = bl = !iFunctionSelector.addFunction(this.function);
        if (bl) {
            evaluationState.addError(new AsmError("The function '" + this.name + "' is already defined.", this.range));
        }
        this.function.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.function.executePrepass(evaluationState);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }
}

