/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.ArrayList;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.AsmNodeList;
import kickass.asmnode.metanodes.ScopeAndSymbolPageNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.Directive;
import kickass.directives.Label;
import kickass.directives.LabelConnector;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolTable;
import kickass.statements.StmtNode;
import kickass.valueholder.ConstantValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.LabelValue;
import kickass.values.ScopeArrayValue;
import kickass.values.ScopeValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ForDirective
extends Directive
implements LabelConnector {
    private List<StmtNode> initStmts;
    private ExprNode conditionExpr;
    private List<ExprNode> iterExprs;
    private AsmNode body;
    private String labelId;
    private SymbolScope countVarScope;
    private SymbolScope innerScope;
    private ISymbolPageIdx labelPageIdx;

    public ForDirective(List<StmtNode> list, ExprNode exprNode, List<ExprNode> list2, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.initStmts = list;
        this.conditionExpr = exprNode;
        this.iterExprs = list2;
        this.body = asmNode;
    }

    private ForDirective(List<StmtNode> list, ExprNode exprNode, List<ExprNode> list2, AsmNode asmNode, SourceRange sourceRange, SymbolScope symbolScope, SymbolScope symbolScope2, String string, ISymbolPageIdx iSymbolPageIdx) {
        super(sourceRange);
        this.initStmts = list;
        this.conditionExpr = exprNode;
        this.iterExprs = list2;
        this.labelId = string;
        this.body = asmNode;
        this.countVarScope = symbolScope;
        this.innerScope = symbolScope2;
        this.labelPageIdx = iSymbolPageIdx;
    }

    @Override
    public boolean connectToLabel(Label label) {
        this.labelId = label.getName();
        return true;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public AsmNode copy() {
        return new ForDirective(this.initStmts, this.conditionExpr, this.iterExprs, this.body.copy(), this.range, this.countVarScope, this.innerScope, this.labelId, this.labelPageIdx);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        this.countVarScope = new SymbolScope(symbolScope, null);
        this.innerScope = new SymbolScope(this.countVarScope, new SymbolTable());
        evaluationState.setCurrentScope(this.countVarScope);
        for (int i = 0; i < this.initStmts.size(); ++i) {
            this.initStmts.get(i).executeMetaRegistrations(evaluationState);
        }
        evaluationState.setCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.setCurrentScope(symbolScope);
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.getCurrentScope().get(this.labelId);
            this.labelPageIdx.replaceInitializer(iValueHolderArray -> new ConstantValueHolder(new LabelValue(new ScopeArrayValue(this.innerScope))));
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        evaluationState.setCurrentScope(this.countVarScope);
        for (StmtNode object : this.initStmts) {
            object.executePrepass(evaluationState);
        }
        this.conditionExpr.executePrepass(evaluationState);
        for (ExprNode exprNode : this.iterExprs) {
            exprNode.executePrepass(evaluationState);
        }
        evaluationState.setCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.setCurrentScope(this.countVarScope.getParent());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        IValueHolder[] iValueHolderArray;
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        evaluationState.clearFunctionSideOutput();
        ScopeArrayValue scopeArrayValue = null;
        if (this.labelPageIdx != null) {
            iValueHolderArray = (IValueHolder[])this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            scopeArrayValue = (ScopeArrayValue)iValueHolderArray.getConnectedValue();
        }
        this.evaluateStmts(this.initStmts, evaluationState);
        while (this.errorIfInvalid(this.conditionExpr.evaluate(evaluationState)).getBoolean(this.range)) {
            arrayList.add(new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput()));
            evaluationState.clearFunctionSideOutput();
            iValueHolderArray = this.innerScope.getSymbolTable().createPage();
            AsmNode asmNode = new ScopeAndSymbolPageNode(this.body.copy(), this.innerScope, iValueHolderArray);
            asmNode = ((AsmNode)asmNode).executePass(evaluationState);
            arrayList.add(asmNode);
            if (scopeArrayValue != null) {
                scopeArrayValue.addScopeValue(new ScopeValue(this.innerScope, iValueHolderArray));
            }
            evaluationState.clearFunctionSideOutput();
            this.evaluateExprs(this.iterExprs, evaluationState);
        }
        arrayList.add(new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput()));
        if (scopeArrayValue != null) {
            scopeArrayValue.setLoopExecuted();
        }
        return new AsmNodeList(arrayList);
    }

    private void evaluateStmts(List<StmtNode> list, EvaluationState evaluationState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).evaluate(evaluationState);
        }
    }

    private void evaluateExprs(List<ExprNode> list, EvaluationState evaluationState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).evaluate(evaluationState);
        }
    }

    private Value errorIfInvalid(Value value) {
        if (value.isInvalid()) {
            throw new AsmErrorException("Can't evaluate condition in first pass", this.range);
        }
        return value;
    }
}

