/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.ByteOutput;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.valueholder.IValueHolder;
import kickass.valueholder.VariableValueHolder;
import kickass.values.NumberValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class FillDirective
extends AsmDirective {
    private List<ExprNode> arguments;
    private ExprNode sizeExpr;
    private ExprNode valueExpr;
    private SymbolScope innerScope;
    private ISymbolPageIdx iSymbolPageIdx;

    @Override
    public AsmNode copy() {
        return this;
    }

    public FillDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.arguments = list;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.arguments.size() != 2) {
            evaluationState.addError(new AsmError("Invalid number of arguments", this.range));
            return EmptyOutput.instance;
        }
        this.sizeExpr = this.arguments.get(0);
        this.innerScope = new SymbolScope(evaluationState.getCurrentScope(), null);
        this.iSymbolPageIdx = this.innerScope.define("i", VariableValueHolder.initializer);
        this.valueExpr = this.arguments.get(1);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.sizeExpr.executePrepass(evaluationState);
        evaluationState.setCurrentScope(this.innerScope);
        this.iSymbolPageIdx.setStatus(SymbolStatus.defined);
        this.valueExpr.executePrepass(evaluationState);
        evaluationState.setCurrentScope(this.innerScope.getParent());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        evaluationState.clearFunctionSideOutput();
        Value value = this.sizeExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("You must be able to determine the size argument en first pass", this.range);
        }
        int n2 = value.getInt(this.range);
        if (n2 < 0) {
            throw new AsmErrorException("The size of a fill directive can't be negative. Size=" + n2, this.range);
        }
        IValueHolder iValueHolder = this.iSymbolPageIdx.getValueHolder();
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            iValueHolder.setWithoutSideEffect(new NumberValue(n));
            Value value2 = this.valueExpr.evaluate(evaluationState);
            if (value2.isInvalid()) continue;
            byArray[n] = (byte)(value2.getInt(this.range) & 0xFF);
        }
        evaluationState.increaseMemoryPosition(n2);
        n = evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation() ? 1 : 0;
        return n != 0 ? this : new ByteOutput(byArray, this.range, evaluationState.getFunctionSideOutput());
    }
}

