/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.Directive;
import kickass.state.EvaluationState;
import kickass.statements.StmtNode;
import kickassu.parsing.sourcelocation.SourceRange;

public class EvalDirective
extends Directive {
    private StmtNode stmt;
    private boolean evalFinished = false;

    public EvalDirective(StmtNode stmtNode, SourceRange sourceRange) {
        super(sourceRange);
        this.stmt = stmtNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.stmt.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.stmt.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        this.stmt.evaluate(evaluationState);
        boolean bl = this.evalFinished = !evaluationState.getErrorDuringFunctionEvaluation();
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public boolean isFinished() {
        return this.evalFinished;
    }
}

