/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.Directive;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ErrorIfDirective
extends Directive {
    private List<ExprNode> argExprs;

    public ErrorIfDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.argExprs = list;
        this.range = sourceRange;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.argExprs.size() != 2) {
            evaluationState.addError(new AsmError("Invalid number of arguments.", this.range));
            return EmptyOutput.instance;
        }
        for (ExprNode exprNode : this.argExprs) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.argExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            return this;
        }
        if (value.getBoolean(this.range)) {
            Value value2 = this.argExprs.get(1).evaluate(evaluationState);
            if (value2.isInvalid()) {
                return this;
            }
            String string = value2.getString(this.range);
            throw new AsmErrorException(string, this.range);
        }
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }
}

