/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.Directive;
import kickass.expressions.ExprNode;
import kickass.sideeffect.SESymbolAssignment;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.tools.tuples.Triple;
import kickass.valueholder.ConstantValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.NumberValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.parsing.sourcelocation.SourceRange;

public class EnumDirective
extends Directive {
    private boolean evalFinished = false;
    private List<Triple<String, SourceRange, ExprNode>> enumList;
    private ISymbolPageIdx[] symbolPageIdxs;

    public EnumDirective(List<Triple<String, SourceRange, ExprNode>> list, SourceRange sourceRange) {
        super(sourceRange);
        this.enumList = list;
        this.symbolPageIdxs = new ISymbolPageIdx[list.size()];
    }

    private EnumDirective(List<Triple<String, SourceRange, ExprNode>> list, SourceRange sourceRange, ISymbolPageIdx[] iSymbolPageIdxArray) {
        super(sourceRange);
        this.enumList = list;
        this.symbolPageIdxs = iSymbolPageIdxArray;
    }

    @Override
    public AsmNode copy() {
        return new EnumDirective(this.enumList, this.range, this.symbolPageIdxs);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        int n = 0;
        for (Triple<String, SourceRange, ExprNode> triple : this.enumList) {
            String string = triple.getA();
            SourceRange sourceRange = triple.getB();
            if (symbolScope.isDefined(string)) {
                evaluationState.addError(new AsmError("The symbol '" + string + "' is already defined", sourceRange));
            }
            int n2 = ++n;
            ++n;
            this.symbolPageIdxs[n2] = symbolScope.define(string, ConstantValueHolder.initializer);
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        int n = 0;
        for (Triple<String, SourceRange, ExprNode> triple : this.enumList) {
            ExprNode exprNode;
            ISymbolPageIdx iSymbolPageIdx;
            if ((iSymbolPageIdx = this.symbolPageIdxs[n++]) != null) {
                iSymbolPageIdx.setStatus(SymbolStatus.defined);
            }
            if ((exprNode = triple.getC()) == null) continue;
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        int n = 0;
        int n2 = 0;
        for (Triple<String, SourceRange, ExprNode> triple : this.enumList) {
            Value value;
            ExprNode exprNode = triple.getC();
            ISymbolPageIdx iSymbolPageIdx = this.symbolPageIdxs[n2++];
            if (exprNode == null) {
                value = new NumberValue(n++);
            } else {
                value = exprNode.evaluate(evaluationState);
                if (value.isInvalidOrInvalidContent()) {
                    evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
                }
            }
            IValueHolder iValueHolder = iSymbolPageIdx.getValueHolder();
            iValueHolder.setWithoutSideEffect(value);
            evaluationState.addSideEffect(new SESymbolAssignment(value, iValueHolder));
        }
        boolean bl = this.evalFinished = !evaluationState.getErrorDuringFunctionEvaluation();
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public boolean isFinished() {
        return this.evalFinished;
    }
}

