/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.misc.CharToPetsciiConverter;
import kickass.sideeffect.SESetEncoding;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class EncodingDirective
extends AsmDirective {
    private ExprNode argExpr;

    public EncodingDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.argExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.argExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("Can't evaluate the encoding value in first parse", this.range);
        }
        String string = value.getString(this.range);
        boolean bl = CharToPetsciiConverter.setCurrentEncoding(string);
        if (!bl) {
            throw new AsmErrorException("Invalid encoding: " + string, this.range);
        }
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        evaluationState.addSideEffect(new SESetEncoding(string));
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }
}

