/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.EmptyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.log.Log;
import kickass.state.EvaluationState;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class EasterEggDirective
extends AsmDirective {
    private static final Log log = new Log("EasterEgg");

    public EasterEggDirective(SourceRange sourceRange) {
        super(sourceRange);
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        String string = "/data/easteregg.prg";
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new AsmErrorException("Can't find the resource " + string, this.range);
        }
        try {
            log.println("Congratulations - You found the easter egg!!");
            String string2 = "easteregg.prg";
            log.println("Writing " + string2);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            this.readDecodeAndWriteFile(inputStream, fileOutputStream);
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            log.error("Error while writing the easteregg");
            log.error(exception);
        }
        return EmptyOutput.instance;
    }

    private void readDecodeAndWriteFile(InputStream inputStream, OutputStream outputStream) throws Exception {
        int n;
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            outputStream.write(n ^ n2 & 0xFF);
            ++n2;
        }
    }
}

