/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import java.util.Map;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.functionnode.FunctionNode;
import kickass.sideeffect.SESymbolAssignment;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.valueholder.ConstantValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.parsing.sourcelocation.SourceRange;

public class DefineDirective
extends AsmDirective {
    private SourceRange range;
    private List<String> ids;
    private FunctionNode body;
    private ISymbolPageIdx[] outerSymbolPageIdxs;
    private ISymbolPageIdx[] innerSymbolPageIdxs;
    private SymbolScope scope;

    public DefineDirective(List<String> list, FunctionNode functionNode, SourceRange sourceRange) {
        super(sourceRange);
        this.body = functionNode;
        this.ids = list;
    }

    @Override
    public AsmNode copy() {
        return new DefineDirective(this.ids, this.body, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        this.outerSymbolPageIdxs = new ISymbolPageIdx[this.ids.size()];
        for (int i = 0; i < this.ids.size(); ++i) {
            String string = this.ids.get(i);
            if (symbolScope.isDefined(string)) {
                evaluationState.addError(new AsmError("The symbol '" + string + "' is already defined", this.range));
                continue;
            }
            this.outerSymbolPageIdxs[i] = symbolScope.define(string, ConstantValueHolder.initializer);
        }
        this.scope = new SymbolScope(symbolScope, null);
        evaluationState.setCurrentScope(this.scope);
        evaluationState.setFunctionMode(true);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.setFunctionMode(false);
        evaluationState.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        Object object;
        int n;
        evaluationState.setCurrentScope(this.scope);
        evaluationState.setFunctionMode(true);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.setFunctionMode(false);
        evaluationState.setCurrentScope(this.scope.getParent());
        this.innerSymbolPageIdxs = new ISymbolPageIdx[this.ids.size()];
        Map<String, ISymbolPageIdx> map = this.scope.getLocalDefinedEntities();
        for (n = 0; n < this.ids.size(); ++n) {
            object = this.ids.get(n);
            ISymbolPageIdx iSymbolPageIdx = map.get(object);
            if (iSymbolPageIdx == null) {
                evaluationState.addError(new AsmError("Define directive doesn't define '" + (String)object + "'", this.range));
                continue;
            }
            this.innerSymbolPageIdxs[n] = iSymbolPageIdx;
        }
        for (n = 0; n < this.outerSymbolPageIdxs.length; ++n) {
            object = this.outerSymbolPageIdxs[n];
            if (object == null) continue;
            object.setStatus(SymbolStatus.defined);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        evaluationState.setCurrentScope(this.scope);
        evaluationState.setFunctionMode(true);
        this.body.executeFunctionPass(evaluationState);
        evaluationState.setFunctionMode(false);
        evaluationState.setCurrentScope(this.scope.getParent());
        for (int i = 0; i < this.outerSymbolPageIdxs.length; ++i) {
            Value value = this.innerSymbolPageIdxs[i].getValueHolder().get(evaluationState, this.range);
            value.lock(this.range);
            IValueHolder iValueHolder = this.outerSymbolPageIdxs[i].getValueHolder();
            iValueHolder.setWithoutSideEffect(value);
            evaluationState.addSideEffect(new SESymbolAssignment(value, iValueHolder));
        }
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }
}

