/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.ByteOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.parsing.sourcelocation.SourceRange;

public class DataBlockDirective
extends AsmDirective {
    private int datasize;
    private List<ExprNode> datalist;

    public DataBlockDirective(int n, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.datasize = n;
        this.datalist = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        for (ExprNode exprNode : this.datalist) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        byte[] byArray = new byte[this.datasize * this.datalist.size()];
        int n = 0;
        boolean bl = false;
        for (ExprNode exprNode : this.datalist) {
            Value value = exprNode.evaluate(evaluationState);
            if (value.isInvalid()) {
                n += this.datasize;
                bl = true;
                continue;
            }
            int n2 = value.getInt(this.range);
            for (int i = 0; i < this.datasize; ++i) {
                byArray[n++] = (byte)(n2 & 0xFF);
                n2 >>= 8;
            }
        }
        evaluationState.increaseMemoryPosition(this.datasize * this.datalist.size());
        if (bl || evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byArray, this.range, evaluationState.getFunctionSideOutput());
    }
}

