/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.ScopeNode;
import kickass.directives.Directive;
import kickass.directives.Label;
import kickass.directives.LabelConnector;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.valueholder.ConstantValueHolder;
import kickass.values.LabelValue;
import kickass.values.ScopeValue;
import kickassu.exceptions.NotImplementedException;

public class BracketScopeDirective
extends Directive
implements LabelConnector {
    private AsmNode body;
    private String nameSpaceId;

    public BracketScopeDirective(AsmNode asmNode) {
        super(null);
        this.body = asmNode;
    }

    private BracketScopeDirective(AsmNode asmNode, String string) {
        super(null);
        this.nameSpaceId = string;
        this.body = asmNode;
    }

    @Override
    public boolean connectToLabel(Label label) {
        this.nameSpaceId = label.getName();
        return true;
    }

    @Override
    public AsmNode copy() {
        return new BracketScopeDirective(this.body.copy(), this.nameSpaceId);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        SymbolScope symbolScope2 = new SymbolScope(symbolScope, null);
        ScopeNode scopeNode = new ScopeNode(this.body, symbolScope2);
        if (this.nameSpaceId != null) {
            ISymbolPageIdx iSymbolPageIdx = symbolScope.get(this.nameSpaceId);
            iSymbolPageIdx.replaceInitializer(iValueHolderArray -> new ConstantValueHolder(new LabelValue(new ScopeValue(symbolScope2, iValueHolderArray))));
        }
        return ((AsmNode)scopeNode).executeMetaRegistrations(evaluationState);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }
}

