/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class AssertErrorDirective
extends AsmDirective {
    private ExprNode testNameExpr;
    private ExprNode expr;
    private SourceRange range;
    private List<AsmError> errorsFound = null;
    boolean preparsed = false;

    public AssertErrorDirective(ExprNode exprNode, ExprNode exprNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.testNameExpr = exprNode;
        this.expr = exprNode2;
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorDirective(this.testNameExpr, this.expr, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.testNameExpr.executePrepass(evaluationState);
        evaluationState.startExpectErrorsMode();
        this.expr.executePrepass(evaluationState);
        this.errorsFound = evaluationState.endExpectErrorsMode();
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        boolean bl = evaluationState.getFunctionsMode();
        int n = evaluationState.getCallStack().getStackSize();
        AsmError asmError = null;
        if (!this.errorsFound.isEmpty()) {
            asmError = this.errorsFound.get(0);
        } else {
            try {
                this.expr.evaluate(evaluationState);
            }
            catch (AsmErrorException asmErrorException) {
                asmError = asmErrorException.getError();
            }
        }
        evaluationState.getCallStack().popTilDepth(n);
        evaluationState.setFunctionMode(bl);
        Value value = this.testNameExpr.evaluate(evaluationState);
        boolean bl2 = evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        if (asmError == null && bl2) {
            return this;
        }
        String string = value.getString(this.range);
        String string2 = asmError != null ? string + " -- OK. | " + asmError.getMessage() : string + " -- ERROR IN ASSERTION!";
        evaluationState.addTextOutput(string2);
        evaluationState.getAssertManager().madeAssert(asmError == null);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }
}

