/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.ScopeNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class AssertErrorCodeDirective
extends AsmDirective {
    private ExprNode testNameExpr;
    private AsmNode body;
    private SourceRange range;
    private List<AsmError> errorsFound = null;
    boolean prepassed = false;

    public AssertErrorCodeDirective(ExprNode exprNode, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.testNameExpr = exprNode;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorCodeDirective(this.testNameExpr, this.body, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = new SymbolScope(evaluationState.getCurrentScope(), null);
        this.body = new ScopeNode(this.body, symbolScope);
        evaluationState.startExpectErrorsMode();
        this.body = this.body.executeMetaRegistrations(evaluationState);
        this.errorsFound = evaluationState.endExpectErrorsMode();
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.testNameExpr.executePrepass(evaluationState);
        evaluationState.startExpectErrorsMode();
        this.body = this.body.executePrepass(evaluationState);
        this.errorsFound.addAll(evaluationState.endExpectErrorsMode());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Integer n = evaluationState.getMemoryPosition();
        boolean bl = evaluationState.getFunctionsMode();
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        int n2 = evaluationState.getCallStack().getStackSize();
        evaluationState.setMemoryPositionWithoutSideEffect(8192);
        AsmError asmError = null;
        if (!this.errorsFound.isEmpty()) {
            asmError = this.errorsFound.get(0);
        } else {
            try {
                this.body = this.body.executePass(evaluationState);
            }
            catch (AsmErrorException asmErrorException) {
                asmError = asmErrorException.getError();
            }
        }
        evaluationState.setMemoryPositionWithoutSideEffect(n);
        evaluationState.setFunctionMode(bl);
        evaluationState.setCurrentScope(symbolScope);
        evaluationState.getCallStack().popTilDepth(n2);
        evaluationState.clearFunctionSideOutput();
        Value value = this.testNameExpr.evaluate(evaluationState);
        if (asmError == null && !this.body.isFinished()) {
            return this;
        }
        String string = value.getString(this.range);
        String string2 = asmError != null ? string + " -- OK. | " + asmError.getMessage() : string + " -- FAILED!";
        evaluationState.addTextOutput(string2);
        evaluationState.getAssertManager().madeAssert(asmError == null);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }
}

