/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.ScopeNode;
import kickass.asmnode.output.SideEffectOnlyOutput;
import kickass.asmnode.output.reciever.CodeCollectorOutputReciever;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.misc.MemoryBlock;
import kickass.misc.StringTool;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.values.Value;
import kickassu.parsing.sourcelocation.SourceRange;

public class AssertCodeDirective
extends AsmDirective {
    ExprNode msgExpr;
    AsmNode resultNode;
    AsmNode expectedNode;
    SourceRange range;

    public AssertCodeDirective(ExprNode exprNode, AsmNode asmNode, AsmNode asmNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.msgExpr = exprNode;
        this.resultNode = asmNode;
        this.expectedNode = asmNode2;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope();
        SymbolScope symbolScope2 = new SymbolScope(symbolScope, null);
        SymbolScope symbolScope3 = new SymbolScope(symbolScope, null);
        this.resultNode = new ScopeNode(this.resultNode, symbolScope2);
        this.expectedNode = new ScopeNode(this.expectedNode, symbolScope3);
        this.resultNode = this.resultNode.executeMetaRegistrations(evaluationState);
        this.expectedNode = this.expectedNode.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.resultNode = this.resultNode.executePrepass(evaluationState);
        this.expectedNode = this.expectedNode.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        boolean bl;
        Integer n = evaluationState.getMemoryPosition();
        evaluationState.setMemoryPositionWithoutSideEffect(8192);
        this.resultNode = this.resultNode.executePass(evaluationState);
        evaluationState.setMemoryPositionWithoutSideEffect(8192);
        this.expectedNode = this.expectedNode.executePass(evaluationState);
        evaluationState.setMemoryPositionWithoutSideEffect(n);
        evaluationState.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        boolean bl2 = evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        boolean bl3 = bl = this.resultNode.isFinished() && this.expectedNode.isFinished() && !bl2;
        if (!bl) {
            return this;
        }
        String string = value.getString(this.range);
        CodeCollectorOutputReciever codeCollectorOutputReciever = new CodeCollectorOutputReciever(8192, evaluationState.getMaxMemoryAddress());
        CodeCollectorOutputReciever codeCollectorOutputReciever2 = new CodeCollectorOutputReciever(8192, evaluationState.getMaxMemoryAddress());
        this.resultNode.deliverOutput(codeCollectorOutputReciever);
        this.expectedNode.deliverOutput(codeCollectorOutputReciever2);
        boolean bl4 = codeCollectorOutputReciever.codeIsEqual(codeCollectorOutputReciever2);
        String string2 = bl4 ? string + " -- OK. | " + this.codeToString(codeCollectorOutputReciever) : string + " -- FAILED! | " + this.codeToString(codeCollectorOutputReciever) + "  -- " + this.codeToString(codeCollectorOutputReciever2);
        evaluationState.addTextOutput(string2);
        evaluationState.getAssertManager().madeAssert(!bl4);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    private String codeToString(CodeCollectorOutputReciever codeCollectorOutputReciever) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (MemoryBlock memoryBlock : codeCollectorOutputReciever.getMemoryBlocks()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("; ");
            }
            stringBuffer.append(StringTool.toHexString(memoryBlock.getStartAdress(), 4));
            stringBuffer.append(":");
            boolean bl2 = true;
            for (byte by : memoryBlock.getMemory()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(StringTool.toHexString(by, 2));
            }
        }
        return stringBuffer.toString();
    }
}

