/*
 * Decompiled with CFR 0.152.
 */
package kickass.directives.asmmode;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.ByteOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class AlignDirective
extends AsmDirective {
    private ExprNode argExpr;

    public AlignDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.argExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.argExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.range);
        if (n <= 0) {
            throw new AsmErrorException("Alignment size must be positive.", this.range);
        }
        Integer n2 = evaluationState.getMemoryPosition();
        if (n2 == null) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n3 = n - n2 % n;
        if (n3 == n) {
            n3 = 0;
        }
        evaluationState.increaseMemoryPosition(n3);
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(new byte[n3], this.range, evaluationState.getFunctionSideOutput());
    }
}

