/*
 * Decompiled with CFR 0.152.
 */
package kickass.asmnode.output.reciever;

import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.asmnode.output.reciever.ByteDumpWriter;
import kickass.asmnode.output.reciever.OutputReciever;
import kickass.asmnode.output.reciever.OutputStreamType;
import kickass.log.Log;
import kickass.misc.MemoryBlock;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class MainOutputReciever
implements OutputReciever {
    private static Log output = new Log("");
    private boolean allowFileOutput = false;
    private Writer dummyWriter = new StringWriter();
    private int maxMemoryAddress;
    private Map<String, Writer> fileOutStreams = new HashMap<String, Writer>();
    private ByteDumpWriter byteDumpWriter;
    private int defaultMemoryPos;
    private List<MemoryBlock> memoryBlocks = new ArrayList<MemoryBlock>();

    public MainOutputReciever(int n, boolean bl, int n2, ByteDumpWriter byteDumpWriter) {
        this.defaultMemoryPos = n;
        this.allowFileOutput = bl;
        this.maxMemoryAddress = n2;
        this.byteDumpWriter = byteDumpWriter;
    }

    @Override
    public void addAssembledBytes(byte[] byArray, SourceRange sourceRange) {
        this.getCurrentMemoryBlock().addBytes(byArray, null);
        if (this.byteDumpWriter != null) {
            this.byteDumpWriter.printBytes(byArray, sourceRange);
        }
    }

    @Override
    public void startNewMemoryBlock(int n, String string, boolean bl) {
        this.memoryBlocks.add(new MemoryBlock(n, string, bl, this.maxMemoryAddress));
        if (this.byteDumpWriter != null) {
            this.byteDumpWriter.startMemoryBlock(n, string, bl);
        }
    }

    @Override
    public List<MemoryBlock> getMemoryBlocks() {
        return this.memoryBlocks;
    }

    @Override
    public void addToStream(OutputStreamType outputStreamType, String string, Object object) {
        if (outputStreamType == OutputStreamType.CONSOLE) {
            output.println("  " + (String)object);
        } else if (outputStreamType == OutputStreamType.FILE) {
            this.addToFileStream(string, object);
        }
    }

    private void addToFileStream(String string, Object object) {
        Writer writer = this.fileOutStreams.get(string);
        if (writer == null) {
            if (!this.allowFileOutput) {
                this.fileOutStreams.put(string, this.dummyWriter);
                return;
            }
            try {
                writer = new FileWriter(string);
            }
            catch (Exception exception) {
                throw new AsmErrorException("Unable to create the file " + string, null);
            }
            this.fileOutStreams.put(string, writer);
        }
        if (!this.allowFileOutput) {
            return;
        }
        try {
            writer.write((String)object);
        }
        catch (Exception exception) {
            throw new AsmErrorException("Error while writing to file " + string, null);
        }
    }

    private MemoryBlock getCurrentMemoryBlock() {
        if (this.memoryBlocks.isEmpty()) {
            this.startNewMemoryBlock(this.defaultMemoryPos, "unnamed", false);
        }
        return this.memoryBlocks.get(this.memoryBlocks.size() - 1);
    }

    public boolean codeIsEqual(OutputReciever outputReciever) {
        List<MemoryBlock> list = outputReciever.getMemoryBlocks();
        if (this.memoryBlocks.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < this.memoryBlocks.size(); ++i) {
            MemoryBlock memoryBlock;
            MemoryBlock memoryBlock2 = this.memoryBlocks.get(i);
            if (memoryBlock2.contentEquals(memoryBlock = list.get(i))) continue;
            return false;
        }
        return true;
    }

    private void closeStreams() {
        if (this.byteDumpWriter != null) {
            this.byteDumpWriter.closeStreams();
        }
        for (Writer writer : this.fileOutStreams.values()) {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public void finish() {
        this.closeStreams();
        if (this.fileOutStreams.isEmpty()) {
            return;
        }
        if (!this.allowFileOutput) {
            output.println("Warning! For security reasons Kick Assembler can't create/overwrite user defined files unless you use the -afo switch (Allow file creation)");
        }
        String string = this.allowFileOutput ? "Wrote file: " : "Blocked file: ";
        for (String string2 : this.fileOutStreams.keySet()) {
            output.println(string + string2);
        }
    }
}

