/*
 * Decompiled with CFR 0.152.
 */
package kickass.asmnode.output.reciever;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.state.EvaluationState;
import kickassu.parsing.sourcelocation.SourceRange;

public class ByteDumpWriter {
    private Writer writer;
    private Writer fileWriter;
    private EvaluationState state;
    private boolean isFirstBlock = true;
    private boolean isVirtual;
    private int currentAddress;
    private Map<String, List<String>> sourceFileLines = new HashMap<String, List<String>>();

    public ByteDumpWriter(String string, int n, EvaluationState evaluationState) throws IOException {
        this.fileWriter = new FileWriter(string);
        this.writer = new BufferedWriter(this.fileWriter);
        this.currentAddress = n;
        this.state = evaluationState;
    }

    public void closeStreams() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startMemoryBlock(int n, String string, boolean bl) {
        try {
            this.currentAddress = n;
            this.isVirtual = bl;
            if (string == null) {
                string = "Unnamed";
            }
            if (this.isFirstBlock) {
                this.isFirstBlock = false;
            } else {
                this.writer.write("\n");
            }
            this.writer.write("[" + string + "]\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printBytes(byte[] byArray, SourceRange sourceRange) {
        try {
            int n;
            int n2 = byArray.length <= 3 ? 3 : 16;
            String string = this.getSourceString(sourceRange);
            for (int i = n = 0; i < byArray.length; i += n2) {
                this.writeBytesLine(byArray, i, i + n2, string);
                string = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeBytesLine(byte[] byArray, int n, int n2, String string) throws IOException {
        if (this.isVirtual) {
            this.writer.write("*");
        }
        this.writer.write(String.format("%04x: ", this.currentAddress));
        for (int i = n; i < n2; ++i) {
            if (i >= byArray.length) {
                this.writer.write("   ");
                continue;
            }
            this.writer.write(String.format("%02x ", byArray[i]));
            ++this.currentAddress;
        }
        if (string != null) {
            this.writer.write(" - ");
            this.writer.write(string);
        }
        this.writer.write("\n");
    }

    public List<String> getSourceFileLines(String string) throws IOException {
        String string2;
        List<String> list = this.sourceFileLines.get(string);
        if (list != null) {
            return list;
        }
        FileInputStream fileInputStream = new FileInputStream(this.state.getFileManager().getFile(string, false));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        list = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            list.add(string2);
        }
        bufferedReader.close();
        this.sourceFileLines.put(string, list);
        return list;
    }

    private String getSourceString(SourceRange sourceRange) throws IOException {
        List<String> list = this.getSourceFileLines(sourceRange.getFileName());
        if (list == null) {
            return null;
        }
        int n = sourceRange.getStartLineNo() - 1;
        if (n >= list.size()) {
            return null;
        }
        String string = list.get(n);
        return string.substring(sourceRange.getStartLinePos() - 1);
    }
}

