/*
 * Decompiled with CFR 0.152.
 */
package kickass.asmnode.metanodes;

import java.io.File;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.reciever.OutputReciever;
import kickass.state.EvaluationState;
import kickass.state.FileManager;

public class SetCurrentDirectoryNode
extends AsmNode {
    private File directory;
    private AsmNode body;

    public SetCurrentDirectoryNode(File file, AsmNode asmNode) {
        this.directory = file;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new SetCurrentDirectoryNode(this.directory, this.body.copy());
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        FileManager fileManager = evaluationState.getFileManager();
        File file = fileManager.replaceCurrentDirectory(this.directory);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        fileManager.setCurrentDirectory(file);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        FileManager fileManager = evaluationState.getFileManager();
        File file = fileManager.replaceCurrentDirectory(this.directory);
        this.body = this.body.executePrepass(evaluationState);
        fileManager.setCurrentDirectory(file);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        FileManager fileManager = evaluationState.getFileManager();
        File file = fileManager.replaceCurrentDirectory(this.directory);
        this.body = this.body.executePass(evaluationState);
        fileManager.setCurrentDirectory(file);
        return this;
    }
}

