/*
 * Decompiled with CFR 0.152.
 */
package kickass.asmnode.metanodes;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.reciever.OutputReciever;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolTable;
import kickass.valueholder.IValueHolder;

public class ScopeAndSymbolPageNode
extends AsmNode {
    private AsmNode body;
    private SymbolScope innerScope;
    private ISymbolTable symbolTable;
    private IValueHolder[] pageValues;

    public ScopeAndSymbolPageNode(AsmNode asmNode, SymbolScope symbolScope) {
        this(asmNode, symbolScope, null);
    }

    public ScopeAndSymbolPageNode(AsmNode asmNode, SymbolScope symbolScope, IValueHolder[] iValueHolderArray) {
        this.body = asmNode;
        this.innerScope = symbolScope;
        this.symbolTable = symbolScope.getSymbolTable();
        this.pageValues = iValueHolderArray;
    }

    @Override
    public AsmNode copy() {
        return new ScopeAndSymbolPageNode(this.body, this.innerScope);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.replaceCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.replaceCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (this.pageValues == null) {
            this.pageValues = this.symbolTable.createPage();
        }
        IValueHolder[] iValueHolderArray = this.symbolTable.replaceCurrentPage(this.pageValues);
        this.body = this.body.executePass(evaluationState);
        this.symbolTable.setCurrentPage(iValueHolderArray);
        return this;
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    public IValueHolder[] getSymbolPage() {
        return this.pageValues;
    }

    @Override
    public String toString() {
        return "ScopeNode[isFinised=" + this.isFinished() + "]";
    }
}

