/*
 * Decompiled with CFR 0.152.
 */
package kickass.asmnode.metanodes;

import java.io.File;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.AddRangeToCallStackNode;
import kickass.asmnode.metanodes.NamespaceNode;
import kickass.asmnode.metanodes.SetCurrentDirectoryNode;
import kickass.asmnode.output.reciever.OutputReciever;
import kickass.state.EvaluationState;
import kickassu.exceptions.NotImplementedException;
import kickassu.parsing.sourcelocation.SourceRange;

public class FileImportNode
extends AsmNode {
    private AsmNode body;
    private File newSourceDir;
    private SourceRange callRange;

    public FileImportNode(AsmNode asmNode, File file, SourceRange sourceRange) {
        this.body = asmNode;
        this.callRange = sourceRange;
        this.newSourceDir = file;
    }

    @Override
    public AsmNode copy() {
        return new FileImportNode(this.body, this.newSourceDir, this.callRange);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        AsmNode asmNode = new AddRangeToCallStackNode(this.callRange, this.body);
        asmNode = new SetCurrentDirectoryNode(this.newSourceDir, asmNode);
        asmNode = new NamespaceNode(asmNode, evaluationState.getRootNamespace());
        return asmNode.executeMetaRegistrations(evaluationState);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    @Override
    public String toString() {
        return "FileImport";
    }
}

