/*
 * Decompiled with CFR 0.152.
 */
package kickass.asmnode.metanodes;

import java.util.ArrayList;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.output.reciever.OutputReciever;
import kickass.state.EvaluationState;

public class AsmNodeList
extends AsmNode {
    private Boolean isFinished = null;
    private List<AsmNode> list;

    public AsmNodeList(AsmNode ... asmNodeArray) {
        this.list = new ArrayList<AsmNode>();
        for (int i = 0; i < asmNodeArray.length; ++i) {
            this.list.add(asmNodeArray[i]);
        }
    }

    public AsmNodeList(List<AsmNode> list) {
        this.list = list;
    }

    @Override
    public boolean isFinished() {
        if (this.isFinished == null) {
            boolean bl = true;
            for (AsmNode asmNode : this.list) {
                bl &= asmNode.isFinished();
            }
            this.isFinished = bl;
        }
        return this.isFinished;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        boolean bl = true;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            AsmNode asmNode = this.list.get(i).executePass(evaluationState);
            this.list.set(i, asmNode);
            bl = bl && asmNode.isFinished();
        }
        this.isFinished = bl;
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        boolean bl = true;
        for (int i = 0; i < this.list.size(); ++i) {
            AsmNode asmNode = this.list.get(i).executePrepass(evaluationState);
            this.list.set(i, asmNode);
            bl = bl && asmNode.isFinished();
        }
        this.isFinished = bl;
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        for (int i = 0; i < this.list.size(); ++i) {
            AsmNode asmNode = this.list.get(i).executeMetaRegistrations(evaluationState);
            this.list.set(i, asmNode);
        }
        return this;
    }

    @Override
    public AsmNode copy() {
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        arrayList.ensureCapacity(this.list.size());
        for (AsmNode asmNode : this.list) {
            arrayList.add(asmNode.copy());
        }
        return new AsmNodeList(arrayList);
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        for (AsmNode asmNode : this.list) {
            asmNode.deliverOutput(outputReciever);
        }
    }

    @Override
    public String toString() {
        return "AsmNodeList[finished=" + this.isFinished + "]";
    }
}

