/*
 * Decompiled with CFR 0.152.
 */
package kickass;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import kickass.AssemblerToolbox;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.AsmNodeList;
import kickass.asmnode.metanodes.NamespaceNode;
import kickass.asmnode.metanodes.ScopeAndSymbolPageNode;
import kickass.asmnode.output.reciever.ByteDumpWriter;
import kickass.asmnode.output.reciever.MainOutputReciever;
import kickass.constant.Constant;
import kickass.function.Function;
import kickass.libraries.Library;
import kickass.log.Log;
import kickass.misc.C64File;
import kickass.misc.MemoryBlock;
import kickass.misc.SymbolFile;
import kickass.misc.ViceSymbolFile;
import kickass.state.AssertManager;
import kickass.state.EvaluationState;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.tools.Timer;
import kickass.tools.tuples.Pair;
import kickass.valueholder.ConstantValueHolder;
import kickass.values.HashtableValue;
import kickassu.assmbleinfo.AssembleInfoManager;
import kickassu.assmbleinfo.FileAssembleInfoWriter;
import kickassu.configuration.optionparser.KickAssemblerConfigFileUtil;
import kickassu.configuration.optionparser.KickAssemblerOptionsConfigParser;
import kickassu.configuration.optionparser.KickAssemblerPluginConfigParser;
import kickassu.configuration.parameters.KickAssemblerParameters;
import kickassu.configuration.parameters.KickAssemblerParametersParser;
import kickassu.errors.AsmError;
import kickassu.errors.printers.OneLineErrorPrinter;
import kickassu.errors.printers.StackTraceErrorPrinter;
import kickassu.exceptions.AsmErrorException;
import kickassu.setup.KickAssemblerSetup;

public class KickAssembler {
    private static final String AUTO_INCLUDED_FILE = "/include/autoinclude.asm";
    private static final String CONFIG_FILE = "/KickAss.cfg";
    private static final String PLUGIN_FILE = "/KickAss.plugin";
    private static Log log = new Log("");

    public static void main(String[] stringArray) {
        System.exit(KickAssembler.main2(stringArray));
    }

    public static int main2(String[] stringArray) {
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        log.println("//       Kick Assembler v4.7 by Mads Nielsen            ");
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        EvaluationState evaluationState = new EvaluationState();
        int n = 0;
        try {
            KickAssembler.gatherParameters(evaluationState, stringArray);
            KickAssembler.assemble(evaluationState);
        }
        catch (AsmErrorException asmErrorException) {
            AsmError asmError = asmErrorException.getError();
            asmError.setCallStack(evaluationState.getCallStack());
            log.error(StackTraceErrorPrinter.instance.printError(asmError, evaluationState));
            n = 1;
        }
        catch (Exception exception) {
            log.error(exception);
            n = 1;
        }
        return n |= KickAssembler.printAsmInfo(evaluationState);
    }

    private static void gatherParameters(EvaluationState evaluationState, String[] stringArray) throws IOException {
        String[] stringArray2;
        KickAssemblerParameters kickAssemblerParameters = evaluationState.getKickAssemblerParams();
        File file = new File(".");
        kickAssemblerParameters.libPath.add(file);
        KickAssemblerPluginConfigParser.parsePluginFile(PLUGIN_FILE, evaluationState);
        String[] stringArray3 = KickAssemblerOptionsConfigParser.parseOptionConfigFile(CONFIG_FILE);
        KickAssemblerParametersParser.parseArgs(stringArray3, kickAssemblerParameters);
        KickAssemblerParametersParser.parseArgs(stringArray, kickAssemblerParameters);
        if (kickAssemblerParameters.inputFileName == null) {
            throw new AsmErrorException("No inputfile supplied.");
        }
        if (!new File(kickAssemblerParameters.inputFileName).exists()) {
            throw new AsmErrorException("Inputfile '" + kickAssemblerParameters.inputFileName + "' doesn't exist.");
        }
        File file2 = evaluationState.getFileManager().getFileOrFail(kickAssemblerParameters.inputFileName, true, null);
        File file3 = file2.getCanonicalFile().getParentFile();
        evaluationState.getFileManager().setCurrentDirectory(file3);
        for (String string : stringArray2 = kickAssemblerParameters.extraCfgFilenames.toArray(new String[0])) {
            File file4 = KickAssemblerConfigFileUtil.getUserSpecifiedConfigFile(string, file3);
            if (file4 == null) {
                log.println("Warning. Can't find configfile : " + string);
                continue;
            }
            String[] stringArray4 = KickAssemblerOptionsConfigParser.parseOptionConfigFile(file4);
            KickAssemblerParametersParser.parseArgs(stringArray4, kickAssemblerParameters);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void assemble(EvaluationState evaluationState) {
        Object object;
        Object object2;
        Object object3;
        AssertManager assertManager;
        void var4_7;
        KickAssemblerParameters kickAssemblerParameters = evaluationState.getKickAssemblerParams();
        if (kickAssemblerParameters.displayLibraries) {
            KickAssembler.displayLibraries(KickAssemblerSetup.getStdLibararies());
            return;
        }
        Log.setDebugging(kickAssemblerParameters.debug);
        Log.setWarnings(kickAssemblerParameters.warnings);
        C64File.allowOverlappingMemoryBlocks(kickAssemblerParameters.allowOverlappingMemoryblocks);
        evaluationState.getFileManager().setSourceLibraryPath(kickAssemblerParameters.libPath);
        evaluationState.getFileManager().setFileReplacementMap(kickAssemblerParameters.fileReplacementMap);
        evaluationState.setMaxMemoryAddress(kickAssemblerParameters.maxMemoryAddress);
        HashtableValue hashtableValue = new HashtableValue().addStringValues(kickAssemblerParameters.cmdLineArguments);
        hashtableValue.lock(null);
        evaluationState.getSystemNamespace().getScope().defineErrorIfExist("cmdLineVars", iValueHolderArray -> new ConstantValueHolder(hashtableValue), evaluationState, "ERROR! cmdLineVars is already defined", null).setStatus(SymbolStatus.defined);
        for (Library object52 : KickAssemblerSetup.getStdLibararies()) {
            evaluationState.addLibrary(object52, evaluationState.getSystemNamespace());
        }
        Set<String> set = evaluationState.getPreprocessoreState().getDefinedSymbols();
        set.addAll(evaluationState.getKickAssemblerParams().defines);
        String string = kickAssemblerParameters.inputFileName;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(0, n);
        }
        if (kickAssemblerParameters.outputfile == null) {
            String string3 = kickAssemblerParameters.binFile ? ".bin" : ".prg";
            kickAssemblerParameters.outputfile = (String)var4_7 + string3;
        }
        long l = System.nanoTime();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("User Arguments: ");
        for (Map.Entry<String, String> entry : kickAssemblerParameters.cmdLineArguments.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(entry.getKey() + "=" + entry.getValue());
        }
        if (!bl) {
            log.println(stringBuffer.toString());
        }
        log.println("parsing");
        long l2 = System.nanoTime();
        InputStream inputStream = new KickAssembler().getClass().getResourceAsStream(AUTO_INCLUDED_FILE);
        AsmNode asmNode = AssemblerToolbox.loadAndLexOrError(inputStream, "KickAss.jar:/include/autoinclude.asm", evaluationState, null);
        if (asmNode == null) {
            return;
        }
        asmNode = new NamespaceNode(asmNode, evaluationState.getSystemNamespace());
        AsmNode asmNode2 = AssemblerToolbox.loadAndLexOrError(kickAssemblerParameters.inputFileName, evaluationState, null);
        if (asmNode2 == null) {
            return;
        }
        asmNode2 = new NamespaceNode(asmNode2, evaluationState.getRootNamespace());
        AsmNodeList asmNodeList = new AsmNodeList(asmNode, asmNode2);
        ScopeAndSymbolPageNode scopeAndSymbolPageNode = new ScopeAndSymbolPageNode(asmNodeList, evaluationState.getSystemNamespace().getScope());
        evaluationState.prepareNewParse();
        long l3 = System.nanoTime();
        AsmNode asmNode3 = scopeAndSymbolPageNode.executeMetaRegistrations(evaluationState);
        long l4 = System.nanoTime();
        asmNode3 = asmNode3.executePrepass(evaluationState);
        KickAssembler.printErrorsAndTerminate(evaluationState);
        if (kickAssemblerParameters.noEval) {
            log.println("Preparse done and no evaluation requested. Exiting.");
            return;
        }
        long l5 = System.nanoTime();
        do {
            evaluationState.prepareNewParse();
            log.println("flex pass " + evaluationState.getPassNo());
            asmNode3 = asmNode3.executePass(evaluationState);
            if (evaluationState.getMadeMetaProgress() || asmNode3.isFinished()) continue;
            evaluationState.prepareNewParse();
            evaluationState.setFailOnInvalidValue(true);
            asmNode3 = asmNode3.executePass(evaluationState);
            throw new AsmErrorException("Made no progress and can't solve the program.. You should have gotten an error. Contact the author!", null);
        } while (!asmNode3.isFinished());
        ByteDumpWriter byteDumpWriter = null;
        try {
            if (kickAssemblerParameters.byteDump) {
                byteDumpWriter = new ByteDumpWriter(kickAssemblerParameters.byteDumpFile, 8192, evaluationState);
            }
        }
        catch (IOException iOException) {
            throw new AsmErrorException("Error while creating ByteDump: " + iOException.getMessage());
        }
        log.println("Output pass");
        MainOutputReciever mainOutputReciever = new MainOutputReciever(8192, kickAssemblerParameters.allowFileOutput, evaluationState.getMaxMemoryAddress(), byteDumpWriter);
        asmNode3.deliverOutput(mainOutputReciever);
        mainOutputReciever.finish();
        long l6 = System.nanoTime();
        if (kickAssemblerParameters.time) {
            log.println("Parse time  = " + (l3 - l2) / 1000000L + " ms");
            log.println("MetaReg time  = " + (l4 - l3) / 1000000L + " ms");
            log.println("PrePass time  = " + (l5 - l4) / 1000000L + " ms");
            log.println("Evaluations passes time  = " + (l6 - l5) / 1000000L + " ms");
            log.println("Total assemble time = " + (l6 - l) / 1000000L + " ms");
        }
        Timer.printTimers();
        if (kickAssemblerParameters.showMemoryMap) {
            log.println();
            log.println(AssemblerToolbox.printMemoryBlocks(mainOutputReciever.getMemoryBlocks()));
        }
        if ((assertManager = evaluationState.getAssertManager()).getNoOfAsserts() > 0) {
            log.println();
            object3 = assertManager.getNoOfFailedAsserts() == 0 ? " failed" : " FAILED!";
            log.println("Made " + assertManager.getNoOfAsserts() + " asserts , " + assertManager.getNoOfFailedAsserts() + (String)object3);
        }
        if (!kickAssemblerParameters.filesForEachMemBlock) {
            KickAssembler.writeC64File(kickAssemblerParameters.outputfile, mainOutputReciever.getMemoryBlocks(), kickAssemblerParameters.fillByte, kickAssemblerParameters.binFile);
        } else {
            object3 = new HashMap();
            for (MemoryBlock memoryBlock : mainOutputReciever.getMemoryBlocks()) {
                if (memoryBlock.isVirtual()) continue;
                ArrayList<MemoryBlock> arrayList = (ArrayList<MemoryBlock>)object3.get(memoryBlock.getName());
                if (arrayList == null) {
                    arrayList = new ArrayList<MemoryBlock>();
                    object3.put(memoryBlock.getName(), arrayList);
                }
                arrayList.add(memoryBlock);
            }
            object2 = new String[]{".bin", ".prg"};
            Pair<String, String> pair = KickAssembler.findFilenameBaseAndPostfix(kickAssemblerParameters.outputfile, (String[])object2);
            for (Object object4 : object3.keySet()) {
                object = pair.getA() + "_" + (String)object4 + pair.getB();
                List list = (List)object3.get(object4);
                if (list.size() != 1) {
                    log.warn("" + list.size() + " blocks have the name '" + (String)object4 + "'. They will be merged in the same file.");
                }
                KickAssembler.writeC64File((String)object, list, kickAssemblerParameters.fillByte, kickAssemblerParameters.binFile);
            }
        }
        if (kickAssemblerParameters.viceSymbols) {
            object3 = new File((String)var4_7).getName() + ".vs";
            object2 = new File(kickAssemblerParameters.outputfile).getParent();
            String string4 = (object2 == null ? "" : (String)object2 + File.separator) + (String)object3;
            log.println("Writing Vice symbol file: " + string4);
            new ViceSymbolFile(evaluationState.getResolvedSymbols()).writeFile(string4);
        }
        if (kickAssemblerParameters.symbolFile) {
            if (kickAssemblerParameters.symbolFileOutputDir == null) {
                object3 = (String)var4_7 + ".sym";
            } else {
                object2 = new File((String)var4_7).getName() + ".sym";
                object3 = kickAssemblerParameters.symbolFileOutputDir + File.separator + (String)object2;
            }
            log.println("Writing Symbol file: " + (String)object3);
            evaluationState.getSystemNamespace().getScope().getSymbolTable().setCurrentPage(scopeAndSymbolPageNode.getSymbolPage());
            new SymbolFile(evaluationState.getRootNamespace()).writeFile((String)object3);
        }
        if (kickAssemblerParameters.executeOnSuccess != null) {
            object3 = kickAssemblerParameters.executeOnSuccess + " " + kickAssemblerParameters.outputfile;
            try {
                Object object4;
                object2 = new StringTokenizer((String)object3);
                String[] stringArray = new String[((StringTokenizer)object2).countTokens()];
                int n2 = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray[n2] = ((StringTokenizer)object2).nextToken();
                    ++n2;
                }
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                object4 = ProcessBuilder.Redirect.to(new File("ExecuteOutputLog.txt"));
                processBuilder.redirectOutput((ProcessBuilder.Redirect)object4);
                processBuilder.redirectError((ProcessBuilder.Redirect)object4);
                object = processBuilder.start();
            }
            catch (Exception exception) {
                log.error("Error while executing external program: " + exception);
            }
        }
    }

    private static int printAsmInfo(EvaluationState evaluationState) {
        boolean bl = evaluationState.getKickAssemblerParams().assembleInfos.isEmpty();
        if (bl) {
            return 0;
        }
        FileAssembleInfoWriter fileAssembleInfoWriter = null;
        String string = evaluationState.getKickAssemblerParams().assembleInfoFilename;
        try {
            fileAssembleInfoWriter = new FileAssembleInfoWriter(evaluationState.getKickAssemblerParams().assembleInfoFilename);
        }
        catch (Exception exception) {
            log.error("Could not create asminfo file: " + string);
            return 1;
        }
        AssembleInfoManager assembleInfoManager = new AssembleInfoManager(fileAssembleInfoWriter);
        assembleInfoManager.WriteInfo(evaluationState);
        return 0;
    }

    private static void displayLibraries(List<Library> list) {
        log.println("DEFAULT CONSTANTS:");
        for (Library library : list) {
            for (Constant object : library.getConstants()) {
                log.println(object.getName());
            }
        }
        log.println();
        log.println("DEFAULT FUNCTIONS:");
        for (Library library : list) {
            for (Function function : library.getFunctions()) {
                log.println(function.getName());
            }
        }
    }

    private static void writeC64File(String string, List<MemoryBlock> list, byte by, boolean bl) {
        C64File c64File = new C64File(list, by);
        log.println("Writing file: " + string);
        c64File.writeFile(string, bl);
    }

    private static Pair<String, String> findFilenameBaseAndPostfix(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            String string3 = string.substring(0, string.length() - string2.length());
            return new Pair<String, String>(string3, string2);
        }
        return new Pair<String, String>(string, "");
    }

    private static void printErrorsAndTerminate(EvaluationState evaluationState) {
        if (!evaluationState.getErrors().isEmpty()) {
            int n = evaluationState.getKickAssemblerParams().showMaxNoOfErrors;
            int n2 = evaluationState.getErrors().size();
            log.println("Got " + n2 + " errors while parsing:");
            for (int i = 0; i < n2 && i < n; ++i) {
                AsmError asmError = evaluationState.getErrors().get(i);
                log.println("  " + OneLineErrorPrinter.instance.printError(asmError, evaluationState));
            }
            if (n2 > n) {
                log.println("  ...");
            }
            log.println();
            throw new AsmErrorException(evaluationState.getErrors().get(0));
        }
    }

    static {
        log.addPrintStream(System.out);
    }
}

