/*
 * Decompiled with CFR 0.152.
 */
package kickass;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.AsmNodeList;
import kickass.misc.MemoryBlock;
import kickass.state.EvaluationState;
import kickass.tools.FileTool;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.setup.KickAssemblerSetup;

public class AssemblerToolbox {
    public static AsmNode loadAndLexOrError(String string, EvaluationState evaluationState, SourceRange sourceRange) {
        AsmNode asmNode = AssemblerToolbox.loadAndLex(string, evaluationState);
        if (asmNode == null) {
            evaluationState.addError(new AsmError("Couldn't load file: " + string, sourceRange));
        }
        return asmNode;
    }

    public static AsmNode loadAndLex(String string, EvaluationState evaluationState) {
        File file = evaluationState.getFileManager().getFile(string, false);
        File file2 = evaluationState.getFileManager().getFile(string, true);
        String string2 = FileTool.getCanonicalFilePath(file2);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            return null;
        }
        return AssemblerToolbox.loadAndLex(bufferedInputStream, string2, evaluationState);
    }

    public static AsmNode loadAndLexOrError(InputStream inputStream, String string, EvaluationState evaluationState, SourceRange sourceRange) {
        AsmNode asmNode = AssemblerToolbox.loadAndLex(inputStream, string, evaluationState);
        if (asmNode == null) {
            evaluationState.addError(new AsmError("Couldn't load file: " + string, sourceRange));
        }
        return asmNode;
    }

    public static AsmNode loadAndLex(InputStream inputStream, String string, EvaluationState evaluationState) {
        List<AsmNode> list;
        ITokenStream iTokenStream = KickAssemblerSetup.getLexer(string, new InputStreamReader(inputStream), evaluationState);
        IDirectiveParser<AsmNode> iDirectiveParser = KickAssemblerSetup.getMainParser(evaluationState);
        try {
            list = iDirectiveParser.parseAll(iTokenStream, evaluationState);
        }
        catch (IOException iOException) {
            return null;
        }
        AsmNodeList asmNodeList = new AsmNodeList(list);
        return asmNodeList;
    }

    public static String printMemoryBlocks(List<MemoryBlock> list) {
        ArrayList<MemoryBlock> arrayList = new ArrayList<MemoryBlock>();
        arrayList.addAll(list);
        Comparator<MemoryBlock> comparator = new Comparator<MemoryBlock>(){

            @Override
            public int compare(MemoryBlock memoryBlock, MemoryBlock memoryBlock2) {
                int n;
                int n2 = memoryBlock.getStartAdress();
                if (n2 < (n = memoryBlock2.getStartAdress())) {
                    return -1;
                }
                if (n2 == n) {
                    return 0;
                }
                return 1;
            }
        };
        Collections.sort(arrayList, comparator);
        String string = "Memory Map\n----------\n";
        for (MemoryBlock memoryBlock : arrayList) {
            int n = memoryBlock.getStartAdress();
            int n2 = memoryBlock.getStartAdress() + memoryBlock.getSize() - 1;
            String string2 = memoryBlock.isVirtual() ? "*" : "";
            string = string + string2 + AssemblerToolbox.intToHexString(n) + "-" + AssemblerToolbox.intToHexString(n2) + " " + memoryBlock.getName() + "\n";
        }
        return string;
    }

    private static String intToHexString(int n) {
        String string = Integer.toHexString(n);
        int n2 = Math.max(4 - string.length(), 0);
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return "$" + string;
    }
}

