/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.ucanaccess.commands.InsertCommand;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.complex.UnsupportedValue;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.OnReloadReferenceListener;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessDatabaseMetadata;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimestampData;

public class Persist2Jet {
    private static HashMap<String, List<String>> columnNamesCache = new HashMap();

    public Map<String, Object> getRowPattern(Object[] varr, Table t) throws SQLException {
        String ntn = SQLConverter.basicEscapingIdentifier(t.getName()).toUpperCase();
        LinkedHashMap<String, Object> vl = new LinkedHashMap<String, Object>();
        int i = 0;
        Iterator<String> it = this.getColumnNames(ntn).iterator();
        while (it.hasNext()) {
            vl.put(it.next(), varr[i++]);
        }
        if (i == 0) {
            throw new SQLException("Cannot read table's metadata");
        }
        return this.escapeIdentifiers(vl, t);
    }

    public Object[] getValues(Map<String, Object> rowPattern, Table t) throws SQLException {
        Object[] values = new Object[rowPattern.size()];
        int i = 0;
        for (Object obj : rowPattern.values()) {
            values[i++] = obj;
        }
        return values;
    }

    private List<String> getColumnNames(String ntn) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ntn = UcanaccessDatabaseMetadata.normalizeName(ntn);
        Connection conq = conn.getHSQLDBConnection();
        if (!columnNamesCache.containsKey(ntn)) {
            ArrayList<String> ar = new ArrayList<String>();
            ResultSet rs = conq.getMetaData().getColumns(null, "PUBLIC", ntn, null);
            while (rs.next()) {
                String cbase = rs.getString("COLUMN_NAME");
                ar.add(cbase.toUpperCase());
            }
            columnNamesCache.put(ntn, ar);
        }
        return columnNamesCache.get(ntn);
    }

    private List<String> getColumnNamesCreate(String ntn) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ArrayList<String> ar = new ArrayList<String>();
        ResultSet rs = conn.getMetaData().getColumns(null, "PUBLIC", ntn, null);
        while (rs.next()) {
            String cbase = rs.getString("COLUMN_NAME");
            ar.add(cbase);
        }
        return ar;
    }

    public void convertRowTypes(Object[] values, Table t) throws SQLException {
        try {
            List columns = t.getColumns();
            Iterator it = columns.iterator();
            for (int i = 0; i < values.length; ++i) {
                int vl;
                Object value = values[i];
                Column column = (Column)it.next();
                if (value == null) continue;
                if (value instanceof TimestampData && column.getType().equals((Object)DataType.SHORT_DATE_TIME)) {
                    TimestampData ts = (TimestampData)value;
                    TimeZone zone = TimeZone.getDefault();
                    GregorianCalendar cal = new GregorianCalendar(zone);
                    long millis = HsqlDateTime.convertMillisToCalendar((Calendar)cal, (long)(ts.getSeconds() * 1000L));
                    Timestamp val = new Timestamp(millis);
                    val.setNanos(ts.getNanos());
                    values[i] = val;
                }
                if (value instanceof BlobData) {
                    BlobData bd = (BlobData)value;
                    JDBCConnection hsqlConn = (JDBCConnection)UcanaccessConnection.getCtxConnection().getHSQLDBConnection();
                    SessionInterface si = hsqlConn.getSession();
                    long length = bd.length(si);
                    values[i] = ((BlobData)value).getBytes(si, 0L, (int)length);
                }
                if (value instanceof JavaObjectData) {
                    JavaObjectData jod = (JavaObjectData)value;
                    Serializable obj = jod.getObject();
                    if (obj instanceof ComplexBase[] && !(obj instanceof UnsupportedValue[])) {
                        values[i] = obj;
                    } else {
                        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.UNSUPPORTED_TYPE);
                    }
                }
                if (!column.getType().equals((Object)DataType.BYTE) || (vl = ((Integer)value).intValue()) >= 0 && vl <= 256) continue;
                throw new SQLException("Data out of range");
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private LinkedHashMap<String, Object> escapeIdentifiers(LinkedHashMap<String, Object> map, Table t) {
        List colums = t.getColumns();
        LinkedHashMap<String, Object> vl = new LinkedHashMap<String, Object>();
        for (Column cl : colums) {
            String ekey;
            String key = cl.getName();
            String keyu = key.toUpperCase();
            String string = ekey = map.containsKey(keyu) ? keyu : SQLConverter.escapeIdentifier(key).toUpperCase();
            if (!map.containsKey(ekey) && map.containsKey(ekey.substring(1, ekey.length() - 1))) {
                ekey = ekey.substring(1, ekey.length() - 1);
            }
            vl.put(key, map.get(ekey));
        }
        return vl;
    }

    private String getNormalizedName(String name, Map<String, String> columnMap) {
        if (columnMap == null) {
            return name;
        }
        return columnMap.containsKey(name) ? columnMap.get(name) : name;
    }

    private List<ColumnBuilder> getColumns(String tableName, Map<String, String> columnMap, String[] types) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ArrayList<ColumnBuilder> arcl = new ArrayList<ColumnBuilder>();
        ResultSet rs = conn.getHSQLDBConnection().getMetaData().getColumns(null, "PUBLIC", tableName.toUpperCase(), null);
        int i = 0;
        while (rs.next()) {
            String name = rs.getString("COLUMN_NAME");
            String nname = this.getNormalizedName(name, columnMap);
            ColumnBuilder cb = new ColumnBuilder(nname);
            short length = (short)rs.getInt("COLUMN_SIZE");
            byte scale = (byte)rs.getInt("DECIMAL_DIGITS");
            DataType dt = null;
            if (length == 0 && types != null) {
                if (types[i].equalsIgnoreCase(TypesMap.AccessType.MEMO.name())) {
                    dt = DataType.MEMO;
                    cb.setType(dt);
                }
                if (types[i].equalsIgnoreCase(TypesMap.AccessType.TEXT.name())) {
                    dt = DataType.TEXT;
                    cb.setType(dt);
                }
            }
            if (types != null && i < types.length && types[i] != null && (types[i].equalsIgnoreCase(TypesMap.AccessType.LONG.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.BYTE.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.CURRENCY.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.INTEGER.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.SINGLE.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.DOUBLE.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.YESNO.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.DATETIME.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.COUNTER.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.AUTOINCREMENT.name()))) {
                dt = TypesMap.map2Jackcess(TypesMap.AccessType.valueOf(types[i].toUpperCase(Locale.US)));
                cb.setType(dt);
                cb.setLengthInUnits((int)((short)dt.getFixedSize()));
            }
            if (dt == null) {
                dt = types != null && i < types.length && types[i] != null && types[i].equalsIgnoreCase(TypesMap.AccessType.NUMERIC.name()) ? DataType.NUMERIC : DataType.fromSQLType((int)rs.getInt("DATA_TYPE"), (int)length);
                cb.setType(dt);
                if (length > 0 && dt.equals((Object)DataType.TEXT)) {
                    cb.setLengthInUnits((int)length);
                }
                if (scale > 0) {
                    cb.setScale((int)scale);
                    if (length > 0) {
                        cb.setPrecision((int)length);
                    }
                }
            }
            if (types != null && i < types.length) {
                if (types[i].equalsIgnoreCase(TypesMap.AccessType.COUNTER.name()) || types[i].equalsIgnoreCase(TypesMap.AccessType.AUTOINCREMENT.name())) {
                    cb.setAutoNumber(true);
                }
                if (types[i].equalsIgnoreCase(TypesMap.AccessType.GUID.name())) {
                    cb.setType(DataType.GUID);
                    cb.setAutoNumber(true);
                }
            }
            arcl.add(cb);
            ++i;
        }
        return arcl;
    }

    private List<IndexBuilder> getIndexBuilders(String tableName, Map<String, String> columnMap) throws SQLException {
        ArrayList<IndexBuilder> arcl = new ArrayList<IndexBuilder>();
        this.addIndexBuildersSimple(tableName, columnMap, arcl);
        return arcl;
    }

    private void checkPK(List<IndexBuilder> arcl, IndexBuilder ibpk) {
        if (ibpk == null) {
            return;
        }
        Iterator<IndexBuilder> itib = arcl.iterator();
        List clspk = ibpk.getColumns();
        ArrayList<String> columnNamesPK = new ArrayList<String>();
        for (IndexBuilder.Column clpk : clspk) {
            columnNamesPK.add(clpk.getName().toUpperCase());
        }
        while (itib.hasNext()) {
            IndexBuilder ib = itib.next();
            List cls = ib.getColumns();
            if (cls.size() != clspk.size()) continue;
            boolean clsPK = true;
            for (IndexBuilder.Column cl : cls) {
                if (columnNamesPK.contains(cl.getName().toUpperCase())) continue;
                clsPK = false;
                break;
            }
            if (!clsPK) continue;
            itib.remove();
        }
    }

    private IndexBuilder getIndexBuilderPK(String tableName, Map<String, String> columnMap) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ResultSet pkrs = conn.getMetaData().getPrimaryKeys(null, "PUBLIC", tableName.toUpperCase());
        IndexBuilder indpk = null;
        while (pkrs.next()) {
            if (indpk == null) {
                String indexName = "PrimaryKey";
                indpk = new IndexBuilder(indexName);
                indpk.setPrimaryKey();
            }
            indpk.addColumns(new String[]{this.getNormalizedName(pkrs.getString("COLUMN_NAME"), columnMap)});
        }
        return indpk;
    }

    private void addIndexBuildersSimple(String tableName, Map<String, String> columnMap, ArrayList<IndexBuilder> arcl) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ResultSet idxrs = conn.getMetaData().getIndexInfo(null, "PUBLIC", tableName, false, false);
        HashMap<String, IndexBuilder> hi = new HashMap<String, IndexBuilder>();
        for (IndexBuilder ib : arcl) {
            hi.put(ib.getName(), ib);
        }
        while (idxrs.next()) {
            boolean asc;
            String colName = this.getNormalizedName(idxrs.getString("COLUMN_NAME"), columnMap);
            String indexName = idxrs.getString("INDEX_NAME");
            boolean unique = !idxrs.getBoolean("NON_UNIQUE");
            String ad = idxrs.getString("ASC_OR_DESC");
            boolean bl = asc = ad == null || ad.equals("A");
            if (!hi.containsKey(indexName)) {
                IndexBuilder ib = new IndexBuilder(indexName);
                if (unique) {
                    ib.setUnique();
                }
                arcl.add(ib);
                hi.put(indexName, ib);
            }
            IndexBuilder toIdx = (IndexBuilder)hi.get(indexName);
            toIdx.addColumns(asc, new String[]{colName});
        }
    }

    private void saveColumnsDefaults(String[] defaults, Boolean[] required, Table table) throws IOException {
        List cols = table.getColumns();
        int j = 0;
        if (defaults != null || required != null) {
            for (Column cl : cols) {
                PropertyMap map = cl.getProperties();
                if (defaults != null && j < defaults.length && defaults[j] != null) {
                    map.put("DefaultValue", DataType.TEXT, (Object)defaults[j]);
                }
                if (required != null && j < required.length && required[j] != null && !cl.isAutoNumber()) {
                    map.put("Required", DataType.BOOLEAN, (Object)required[j]);
                }
                map.save();
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(String tableName, Map<String, String> columnMap, String[] types, String[] defaults, Boolean[] notNulls) throws IOException, SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        String tn = tableName;
        String ntn = tableName;
        if (tn.startsWith("[") && tn.endsWith("]") || tn.startsWith("`") && tn.endsWith("`")) {
            tn = tn.substring(1, tn.length() - 1);
            ntn = SQLConverter.preEscapingIdentifier(tn);
        }
        Metadata mtd = new Metadata(conn.getHSQLDBConnection());
        TableBuilder tb = new TableBuilder(tn);
        int idTable = mtd.newTable(tn, ntn, Metadata.Types.TABLE);
        List<ColumnBuilder> lcb = this.getColumns(ntn, columnMap, types);
        tb.addColumns(lcb);
        for (ColumnBuilder cb : lcb) {
            mtd.newColumn(cb.getName(), SQLConverter.preEscapingIdentifier(cb.getName()), cb.getType().name(), idTable);
        }
        List<IndexBuilder> arcl = this.getIndexBuilders(ntn, columnMap);
        IndexBuilder ibpk = this.getIndexBuilderPK(ntn, columnMap);
        this.checkPK(arcl, ibpk);
        if (ibpk != null) {
            arcl.add(ibpk);
        }
        for (IndexBuilder ixb : arcl) {
            tb.addIndex(ixb);
        }
        Table table = tb.toTable(db);
        this.saveColumnsDefaults(defaults, notNulls, table);
        LoadJet lj = new LoadJet(conn.getHSQLDBConnection(), db);
        lj.loadDefaultValues(table);
        Statement st = null;
        try {
            st = conn.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM " + tableName);
            List<String> clns = this.getColumnNamesCreate(tn);
            while (rs.next()) {
                Object[] record = new Object[clns.size()];
                int i = 0;
                for (String columnName : clns) {
                    record[i++] = rs.getObject(columnName);
                }
                new InsertCommand(table, record, null).persist();
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void dropTable(String tableName) throws IOException, SQLException {
        Row row;
        Table t;
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        if (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) {
            tableName = tableName.substring(1, tableName.length() - 1);
        }
        if ((t = db.getTable(tableName)) == null) {
            return;
        }
        Metadata mt = new Metadata(conn.getHSQLDBConnection());
        mt.dropTable(t.getName());
        Cursor c = t.getDefaultCursor();
        while (c.getNextRow() != null) {
            c.deleteCurrentRow();
        }
        DatabaseImpl dbi = (DatabaseImpl)db;
        TableImpl cat = dbi.getSystemCatalog();
        Cursor catc = cat.getDefaultCursor();
        while ((row = catc.getNextRow()) != null) {
            String name = (String)row.get("Name");
            if (name == null || !name.equalsIgnoreCase(tableName)) continue;
            Integer id = (Integer)row.get("Id");
            Table tsa = db.getSystemTable("MSysACEs");
            HashMap<String, Integer> rowtsa = new HashMap<String, Integer>();
            rowtsa.put("ObjectId", id);
            Cursor cur = tsa.getDefaultCursor();
            if (cur.findNextRow(rowtsa)) {
                cur.deleteCurrentRow();
            }
            catc.deleteCurrentRow();
            Table srs = db.getSystemTable("MSysRelationships");
            Cursor srsc = srs.getDefaultCursor();
            while ((row = srsc.getNextRow()) != null) {
                String szObject = (String)row.get("szObject");
                String szReferencedObject = (String)row.get("szReferencedObject");
                if ((szObject == null || !szObject.equalsIgnoreCase(tableName)) && (szReferencedObject == null || !szReferencedObject.equalsIgnoreCase(tableName))) continue;
                srsc.deleteCurrentRow();
            }
        }
        conn.reloadDbIO();
    }

    static {
        DBReference.addOnReloadRefListener(new OnReloadReferenceListener(){

            @Override
            public void onReload() {
                columnNamesCache.clear();
            }
        });
    }
}

